/*
 * sys_get_core.c - get calling core cluster and local index.
 * 
 * Author    Alain Greiner (2016,2017)
 *  
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_uspace.h>
#include <hal_special.h>
#include <errno.h>
#include <core.h>
#include <thread.h>
#include <process.h>
#include <vmm.h>
#include <printk.h>


/////////////////////////////////
int sys_get_core( uint32_t * cxy,
                  uint32_t * lid )
{
    paddr_t   paddr;
    uint32_t  k_cxy;
    uint32_t  k_lid;

	error_t   error = 0;

    thread_t  * this    = CURRENT_THREAD;
    process_t * process = this->process;

    // check buffers in user space
    error |= vmm_v2p_translate( false , cxy , &paddr );
    error |= vmm_v2p_translate( false , lid , &paddr );

	if( error )
	{
        printk("\n[ERROR] in %s : user buffer unmapped for thread %x in process %x\n",
        __FUNCTION__ , this->trdid , process->pid );
        this->errno = EFAULT;
		return -1;
	}

    // get parameters
	k_cxy = local_cxy;
	k_lid = this->core->lid;

    // copy to user space
	hal_copy_to_uspace( cxy , &k_cxy , sizeof(uint32_t) );
	hal_copy_to_uspace( lid , &k_lid , sizeof(uint32_t) );

	return 0; 

}  // end sys_get_core()
