///////////////////////////////////////////////////////////////////////////////
// File   :  pgcd.c
// Date   :  November 2017
// Author :  Alain Greiner <alain.greiner@lip6.fr>
///////////////////////////////////////////////////////////////////////////////
// This single thread interactive application computes the PGCD.
///////////////////////////////////////////////////////////////////////////////


#include <stdlib.h>


///////////
void main()
{
    int opx;
    int opy;

    printf( "*** Starting interactive pgcd ***\n\n" ); 

    while (1) 
    {
        printf("\n*******************\n");
        printf("operand X = ");
        opx = getint();
        printf("\n");
        printf("operand Y = ");
        opy = getint();
        printf("\n");

        if( (opx == 0) || (opy == 0) ) 
        {
           printf("operands must be positive and larger than 0\n");
        } 
        else 
        {
            while (opx != opy) 
            {
                if(opx > opy)   opx = opx - opy;
                else            opy = opy - opx;
            }
            printf("pgcd      = %d\n", opx);
        }
    }
} // end pgcd

