/*
 * signal.h - signal-management related operations
 * 
 * Author  Ghassan Almaless (2008,2009,2010,2011,2012)
 *         Mohamed Lamine Karaoui (2015) 
 *         Alain Greiner    (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SIGNAL_H_
#define _SIGNAL_H_

#include <hal_types.h>


/****  Forward declarations  ****/

struct process_s;
struct thread_s;

typedef uint32_t         sigval_t;
typedef uint32_t         sigset_t;

/*******************************************************************************************
 * This structure ... TODO
 ******************************************************************************************/

typedef struct siginfo_s
{
	int      si_signo;    /*! Signal number */
	int      si_errno;    /*! An errno value */
	int      si_code;     /*! Signal code */
	pid_t    si_pid;      /*! Sending process ID */
	uid_t    si_uid;      /*! Real user ID of sending process */
	int      si_status;   /*! Exit value or signal */
	cycle_t  si_utime;    /*! User time consumed */
	cycle_t  si_stime;    /*! System time consumed */
	sigval_t si_value;    /*! Signal value */
	int      si_int;      /*! POSIX.1b signal */
	void    *si_ptr;      /*! POSIX.1b signal */
	void    *si_addr;     /*! Memory location which caused fault */
	int      si_band;     /*! Band event */
	int      si_fd;       /*! File descriptor */
}
siginfo_t;

/*******************************************************************************************
 * This structure ... TODO
 ******************************************************************************************/

typedef void (sa_handler_t) ( uint32_t sig );

typedef struct sigaction_s 
{
	sigset_t sa_mask;
	uint32_t sa_flags;
	union
	{ 
		sa_handler_t *sa_handler;
		void (*sa_sigaction)(int, siginfo_t *, void *);
	};
}
sigaction_t;

/*******************************************************************************************
 * This structure ... TODO
 ******************************************************************************************/

typedef struct sig_mgr_s
{
	sa_handler_t        * sigactions[SIG_NR];
    struct thread_s     * handler;
}
sig_mgr_t;

/*******************************************************************************************
 * This function ... TODO
 ******************************************************************************************/
int sys_sigreturn_setup( void * sigreturn_func );


/*******************************************************************************************
 * This function ... TODO
 ******************************************************************************************/
void signal_manager_init( struct process_s * process );

/*******************************************************************************************
 * This function register the signal <sig> in the bit-vector of all threads of a given
 * process identified by its <pid>, in a given cluster.
 * It must be executed by a thread running in the same cluster as the target threads
 * (can be a local thread or a RPC thread).
 *******************************************************************************************
 * @ process   : local pointer on local target process. 
 * @ sig_id    : signal type.
 ******************************************************************************************/
void signal_rise( struct process_s * process, 
                  uint32_t           sig_id );

/*******************************************************************************************
 * This function TODO
 ******************************************************************************************/
void signal_notify( struct thread_s * this);

/*******************************************************************************************
 * This function do nothing in this implementation.
 ******************************************************************************************/
#define signal_manager_destroy(task)

#endif	/*! _SIGNAL_H_ */
