#ifndef _SHARED_MMAN_H_
#define _SHARED_MMAN_H_

typedef enum
{
    PROT_NONE   = 0x0,         /*! no access                                              */
    PROT_EXEC   = 0x1,         /*! executable                                             */
    PROT_WRITE  = 0x2,         /*! writable                                               */
    PROT_READ   = 0x4,         /*! readable                                               */
}
mmap_prot_t;

typedef enum
{
    MAP_FILE    = 0x00000000,  /*! map an open file defined by its fdid                   */ 
    MAP_ANON    = 0x00000001,  /*! map an anonymous vseg in local cluster                 */
    MAP_REMOTE  = 0x00000002,  /*! map an anonymous vseg in remote cluster (cxy == fdid)  */
    MAP_PRIVATE = 0x00000010,  /*!                                                        */
    MAP_SHARED  = 0x00000020,  /*!                                                        */
    MAP_FIXED   = 0x00000100,  /*! non supported                                          */
}
mmap_flags_t;

typedef struct mmap_attr_s
{
	void         * addr;       /*! requested virtual address (unused : should be NULL)    */
	unsigned int   length;     /*! requested vseg size (bytes)                            */
	unsigned int   prot;       /*! access modes                                           */
	unsigned int   flags;      /*! MAP_FILE / MAP_ANON / MAP_PRIVATE / MAP_SHARED         */
	unsigned int   fdid;       /*! file descriptor index (if MAP_FILE)                    */
	unsigned int   offset;     /*! file offset (if MAP_FILE)                              */
}
mmap_attr_t;

#endif
