#ifndef _SHARED_ALMOSMKH_H_
#define _SHARED_ALMOSMKH_H_

/******************************************************************************************* 
 * This enum defines the operation mnemonics for the "utls" syscall (Thread Local Storage).
 ******************************************************************************************/

typedef enum
{
    UTLS_SET       = 1,
    UTLS_GET       = 2,
    UTLS_GET_ERRNO = 3,
}
utls_operation_t;

/******************************************************************************************* 
 * This enum defines the operation mnemonics for the "trace" syscall.
 ******************************************************************************************/

typedef enum
{
    TRACE_ON       = 0,
    TRACE_OFF      = 1,
}
trace_operation_t;


/******************************************************************************************* 
 * This enum defines the type of structure for the "display" syscall.
 ******************************************************************************************/

typedef enum
{
    DISPLAY_STRING            = 0,
    DISPLAY_VMM               = 1,
    DISPLAY_SCHED             = 2,
    DISPLAY_CLUSTER_PROCESSES = 3,
    DISPLAY_VFS               = 4,
    DISPLAY_CHDEV             = 5,
    DISPLAY_TXT_PROCESSES     = 6,
}
display_type_t;


#endif /* _ALMOSMKH_H_ */

