#ifndef _SHARED_FCNTL_H_
#define _SHARED_FCNTL_H_

/******************************************************************************************* 
 * This enum defines the attributes bit-vector for an "open" syscall.
 ******************************************************************************************/

typedef enum
{
    O_RDONLY   = 0x0010000,    /*! open file in read-only mode                            */
    O_WRONLY   = 0x0020000,    /*! open file in write-only mode                           */
    O_RDWR     = 0x0030000,    /*! open file in read/write mode                           */
    O_NONBLOCK = 0x0040000,    /*! do not block if data non available                     */
    O_APPEND   = 0x0080000,    /*! append on each write                                   */
    O_CREAT    = 0x0100000,    /*! create file if it does not exist                       */
    O_TRUNC    = 0x0200000,    /*! file length is forced to 0                             */
    O_EXCL     = 0x0400000,    /*! error if VFS_O_CREAT and file exist                    */
    O_SYNC	   = 0x0800000,    /*! synchronize File System on each write                  */
    O_CLOEXEC  = 0x1000000,    /*! set the close-on-exec flag in file descriptor          */
    O_DIR      = 0x2000000,    /*! new file descriptor is for a directory                 */
}
open_attr_t;

#endif
