///////////////////////////////////////////////////////////////////////////////
// File   :  pgcd.c
// Date   :  November 2017
// Author :  Alain Greiner <alain.greiner@lip6.fr>
///////////////////////////////////////////////////////////////////////////////
// This single thread interactive application computes the PGCD.
///////////////////////////////////////////////////////////////////////////////


#include <stdio.h>
#include <almosmkh.h>

///////////
void main()
{
    int                opx;
    int                opy;
    unsigned long long cycle;

    get_cycle( &cycle );
    printf( "\n\n[PGCD] starts / cycle %d\n", (unsigned int)cycle ); 

    while (1) 
    {
        printf("\n*******************\n");
        printf("operand X = ");
        opx = getint();
        printf("\n");
        printf("operand Y = ");
        opy = getint();
        printf("\n");

        if( (opx == 0) || (opy == 0) ) 
        {
           printf("operands must be positive and larger than 0\n");
        } 
        else 
        {
            while (opx != opy) 
            {
                if(opx > opy)   opx = opx - opy;
                else            opy = opy - opx;
            }
            printf("pgcd      = %d", opx);
        }
    }
} // end pgcd

