/*
 * hal_smpboot.S - Kernel SMP entry point
 *
 * Copyright (c) 2017 Maxime Villard
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*
 * Copyright (c) 2000, 2016 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by RedBack Networks Inc. (Author: Bill Sommerfeld), and Maxime Villard.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Copyright (c) 1999 Stefan Grefen
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the NetBSD 
 *      Foundation, Inc. and its contributors.  
 * 4. Neither the name of The NetBSD Foundation nor the names of its 
 *    contributors may be used to endorse or promote products derived  
 *    from this software without specific prior written permission.   
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR AND CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#define x86_ASM
#include <hal_boot.h>
#include <hal_register.h>
#include <hal_kentry.h>
#include <hal_segmentation.h>

#define	RELOC(x)	((x) - KERNBASE)
#define TRAMP_LABEL(a)	a = . - cpuN_boot_trampoline + SMP_TRAMPOLINE_PA

	.global cpuN_boot_trampoline
	.global cpuN_boot_trampoline_end
	.global init_x86_64_cpuN

	.text
	.align 4,0x0
	.code16

LABEL(cpuN_boot_trampoline)
	cli
	xorw	%ax,%ax
	movw	%ax,%ds
	movw	%ax,%es
	movw	%ax,%ss
	data32 addr32 lgdt (smptramp_gdt32_desc) /* load flat descriptor table */

	/* enable protected mode */
	movl	%cr0,%eax
	orl	$CR0_PE,%eax
	movl	%eax,%cr0
	ljmpl	$0x8,$smp_startup

TRAMP_LABEL(smp_startup)
	.code32

	movl	$0x10,%eax	/* data segment */
	movw	%ax,%ds
	movw	%ax,%ss
	movw	%ax,%es
	movw	%ax,%fs
	movw	%ax,%gs

	/* bootstrap stack end, with scratch space.. */
	movl	$(SMP_TRAMPOLINE_PA+PAGE_SIZE-16),%esp

	/* First, reset the PSL. */
	pushl	$PSL_MBO
	popfl

	/* Enable PAE, SSE, and PSE */
	movl	%cr4,%eax
	orl	$(CR4_PAE|CR4_OSFXSR|CR4_OSXMMEXCPT|CR4_PGE|CR4_PSE),%eax
	movl	%eax,%cr4

	/*
	 * Set Long Mode Enable in EFER. Also enable the syscall extensions,
	 * and NOX.
	 */
	movl	$MSR_EFER,%ecx
	rdmsr
	xorl	%eax,%eax
	orl	$(EFER_LME|EFER_SCE|EFER_NXE),%eax
	wrmsr

	/* Load %cr3. */
	movl	RELOC(smp_L4pa),%ecx	/* guaranteed < 4G */
	movl	%ecx,%cr3		/* load PTD addr into MMU */

	/* Enable paging and the rest of it. */
	movl	%cr0,%eax
	orl	$(CR0_PE|CR0_PG|CR0_NE|CR0_TS|CR0_MP|CR0_WP|CR0_AM),%eax
	andl	$~(CR0_CD|CR0_NW),%eax
	orl	$(CR0_EM),%eax	/* FPU not implemented yet */
	movl	%eax,%cr0

	jmp	smptramp_compat
smptramp_compat:

	movl	$GDT_FIXED_SEL(GDT_KDATA_SEL, SEL_KPL),%eax	/* switch to new segment */
	movl	%eax,%ds
	movl	%eax,%es
	movl	%eax,%ss

	movl	$smptramp_gdt64_desc,%eax
	lgdt	(%eax)
	movl	$smptramp_jmp64,%eax
	ljmp	*(%eax)

TRAMP_LABEL(smptramp_jmp64)
	.long	smptramp_longmode
	.word	GDT_FIXED_SEL(GDT_KCODE_SEL, SEL_KPL)

#define GDT_LIMIT	0x17	/* 23 = 3 * 8 - 1 */
TRAMP_LABEL(smptramp_gdt32)
	.quad 0x0000000000000000
	.quad 0x00cf9f000000ffff	/* CS */
	.quad 0x00cf93000000ffff	/* DS */
TRAMP_LABEL(smptramp_gdt32_desc)
	.word GDT_LIMIT
	.long smptramp_gdt32

TRAMP_LABEL(smptramp_gdt64)
	.quad 0x0000000000000000
	.quad 0x00af9a000000ffff	/* CS */
	.quad 0x00cf92000000ffff	/* DS */
TRAMP_LABEL(smptramp_gdt64_desc)
	.word GDT_LIMIT
	.long smptramp_gdt64
#undef	GDT_LIMIT

TRAMP_LABEL(smptramp_longmode)
	.code64
	movabsq	$cpuN_boot_trampoline_end,%rax
	jmp	*%rax

LABEL(cpuN_boot_trampoline_end)
	movq	smp_stkva(%rip),%rsp
	xorq	%rbp,%rbp
	call	init_x86_64_cpuN

	.data

	.globl	smp_L4pa
	.globl	smp_stkva

	.type	smp_L4pa, @object
	smp_L4pa:	.quad	0	/* paddr of L4 */

	.type	smp_stkva, @object
	smp_stkva:	.quad	0	/* vaddr of stack */

