/*
 * kernel_config.h - global kernel configuration arguments
 * 
 * Authors  Ghassan Almaless (2008,2009,2010,2011,2012) 
 *          Mohamed Lamine Karaoui (2015)
 *          Alain Greiner (2016,2017,2018)
 *
 * Copyright (c)  UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _ALMOS_CONFIG_H_
#define _ALMOS_CONFIG_H_

#define CONFIG_ALMOS_VERSION                "Version 1.0 / March 2018"

////////////////////////////////////////////////////////////////////////////////////////////
//                              KERNEL DEBUG
//  Each debug variable control one kernel function, or one small group of functions. 
//  - trace is generated only when cycle > debug_value.
//  - detailed trace is enabled when (debug_value & Ox1) is non zero.
////////////////////////////////////////////////////////////////////////////////////////////

#define DEBUG_CHDEV_CMD_RX             0
#define DEBUG_CHDEV_CMD_TX             0
#define DEBUG_CHDEV_SERVER_RX          0
#define DEBUG_CHDEV_SERVER_TX          0

#define DEBUG_CLUSTER_INIT             0
#define DEBUG_CLUSTER_PID_ALLOC        0
#define DEBUG_CLUSTER_PID_RELEASE      0
#define DEBUG_CLUSTER_PROCESS_COPIES   0

#define DEBUG_DEV_TXT_RX               0
#define DEBUG_DEV_TXT_TX               0
#define DEBUG_DEV_IOC_RX               0
#define DEBUG_DEV_IOC_TX               0
#define DEBUG_DEV_NIC_RX               0
#define DEBUG_DEV_NIC_RX               0
#define DEBUG_DEV_FBF_RX               0
#define DEBUG_DEV_FBF_TX               0
#define DEBUG_DEV_DMA                  0
#define DEBUG_DEV_MMC                  0
#define DEBUG_DEV_PIC                  0

#define DEBUG_DEVFS_INIT               0
#define DEBUG_DEVFS_MOVE               0

#define DEBUG_FATFS_INIT               0
#define DEBUG_FATFS_MOVE               0
#define DEBUG_FATFS_LOAD               0

#define DEBUG_HAL_GPT_ACCESS           0
#define DEBUG_HAL_GPT_CREATE           0
#define DEBUG_HAL_GPT_DESTROY          0

#define DEBUG_HAL_KENTRY               0
#define DEBUG_HAL_EXCEPTIONS           0
#define DEBUG_HAL_IRQS                 0       
#define DEBUG_HAL_TXT_RX               0
#define DEBUG_HAL_TXT_TX               0
#define DEBUG_HAL_IOC_RX               0
#define DEBUG_HAL_IOC_TX               0
#define DEBUG_HAL_GPT

#define DEBUG_KCM                      0
#define DEBUG_KMEM                     0

#define DEBUG_KERNEL_INIT              0
#define DEBUG_KMEM_ALLOC               0

#define DEBUG_MAPPER_GET_PAGE          0
#define DEBUG_MAPPER_MOVE_USER         0
#define DEBUG_MAPPER_MOVE_KERNEL       0

#define DEBUG_PPM_ALLOC_PAGES          0
#define DEBUG_PPM_FREE_PAGES           0

#define DEBUG_PROCESS_COPY_INIT        0
#define DEBUG_PROCESS_DESTROY          0
#define DEBUG_PROCESS_GET_LOCAL_COPY   0
#define DEBUG_PROCESS_INIT_CREATE      0
#define DEBUG_PROCESS_MAKE_EXEC        0
#define DEBUG_PROCESS_MAKE_FORK        0
#define DEBUG_PROCESS_REFERENCE_INIT   0
#define DEBUG_PROCESS_SIGACTION        0
#define DEBUG_PROCESS_TXT              0
#define DEBUG_PROCESS_ZERO_CREATE      0

#define DEBUG_RPC_CLIENT_GENERIC       0
#define DEBUG_RPC_SERVER_GENERIC       0

#define DEBUG_RPC_PMEM_GET_PAGES       0
#define DEBUG_RPC_PMEM_RELEASE_PAGES   0
#define DEBUG_RPC_PROCESS_MAKE_FORK    0
#define DEBUG_RPC_PROCESS_SIGACTION    0
#define DEBUG_RPC_VFS_DENTRY_CREATE    0
#define DEBUG_RPC_VFS_DENTRY_DESTROY   0
#define DEBUG_RPC_VFS_FILE_CREATE      0
#define DEBUG_RPC_VFS_FILE_DESTROY     0
#define DEBUG_RPC_VMM_GET_PTE          0
#define DEBUG_RPC_VMM_GET_VSEG         0

#define DEBUG_SCHED_HANDLE_SIGNALS     2
#define DEBUG_SCHED_YIELD              2    // must be activated by the trace() syscall

#define DEBUG_SYSCALLS_ERROR           2

#define DEBUG_SYS_DISPLAY              0
#define DEBUG_SYS_EXEC                 1
#define DEBUG_SYS_EXIT                 1
#define DEBUG_SYS_FG                   0
#define DEBUG_SYS_FORK                 0
#define DEBUG_SYS_GET_CONFIG           0
#define DEBUG_SYS_ISATTY               0
#define DEBUG_SYS_KILL                 0
#define DEBUG_SYS_MMAP                 0
#define DEBUG_SYS_READ                 0
#define DEBUG_SYS_THREAD_CANCEL        0
#define DEBUG_SYS_THREAD_CREATE        0
#define DEBUG_SYS_THREAD_EXIT          0
#define DEBUG_SYS_THREAD_JOIN          0
#define DEBUG_SYS_THREAD_SLEEP         0
#define DEBUG_SYS_THREAD_WAKEUP        0
#define DEBUG_SYS_THREAD_YIELD         0
#define DEBUG_SYS_TRACE                0
#define DEBUG_SYS_WAIT                 0
#define DEBUG_SYS_WRITE                0

#define DEBUG_SPINLOCKS                0
#define DEBUG_REMOTE_SPINLOCKS         0
#define DEBUG_RWLOCKS                  0
#define DEBUG_REMOTE_RWLOCKS           0

#define DEBUG_THREAD_DESTROY           0
#define DEBUG_THREAD_IDLE              0
#define DEBUG_THREAD_INIT              0
#define DEBUG_THREAD_KERNEL_CREATE     0
#define DEBUG_THREAD_KILL              0
#define DEBUG_THREAD_USER_CREATE       0
#define DEBUG_THREAD_USER_FORK         0
#define DEBUG_THREAD_BLOCK             0

#define DEBUG_VFS_INODE_CREATE         0
#define DEBUG_VFS_INODE_LOAD           0
#define DEBUG_VFS_DENTRY_CREATE        0
#define DEBUG_VFS_OPEN                 0
#define DEBUG_VFS_LOOKUP               0
#define DEBUG_VFS_ADD_CHILD            0
#define DEBUG_VFS_MAPPER_MOVE          0
#define DEBUG_VFS_MAPPER_LOAD          0

#define DEBUG_VMM_CREATE_VSEG          0
#define DEBUG_VMM_DESTROY              0
#define DEBUG_VMM_FORK_COPY            0
#define DEBUG_VMM_GET_ONE_PPN          0
#define DEBUG_VMM_GET_PTE              0
#define DEBUG_VMM_HANDLE_PAGE_FAULT    0
#define DEBUG_VMM_INIT                 0
#define DEBUG_VMM_PAGE_ALLOCATE        0
#define DEBUG_VMM_SET_COW              0
#define DEBUG_VMM_UNMAP_VSEG           0
#define DEBUG_VMM_UPDATE_PTE           0

////////////////////////////////////////////////////////////////////////////////////////////
//                          HARDWARE CONFIGURATION     
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_KERNEL_IDENTITY_MAP          true       // True for 32 bits cores             
#define CONFIG_MAX_CLUSTER                  256        // max number of clusters
#define CONFIG_MAX_LOCAL_CORES              4          // max number of cores per cluster
#define CONFIG_MAX_INT_DEV                  4          // max number of internal peripherals
#define CONFIG_MAX_EXT_DEV                  8          // max number of external peripherals
#define CONFIG_MAX_INTERNAL_IRQS            32         // max number of HWI per ICU
#define CONFIG_MAX_EXTERNAL_IRQS            32         // max number of PTI per ICU
#define CONFIG_IRQS_PER_CORE                4          // number of input IRQs per core
#define CONFIG_CLUSTER_SPAN                 32         // ln(phys. address space per cluster)
#define CONFIG_CACHE_LINE_SIZE              64         // number of bytes in cache line

#define CONFIG_CACHE_LINE_ALIGNED           __attribute__((aligned(CONFIG_CACHE_LINE_SIZE)))

#define CONFIG_MAX_IOC_CHANNELS             1          // max number of IOC device channels
#define CONFIG_MAX_FBF_CHANNELS             1          // max number of FBF device channels
#define CONFIG_MAX_TXT_CHANNELS             8          // max number of TXT device channels
#define CONFIG_MAX_DMA_CHANNELS             4          // max number of DMA device channels
#define CONFIG_MAX_NIC_CHANNELS             4          // max number of NIC device channels

#define CONFIG_MAX_CLUSTERS                 256        // max number of clusters

#define CONFIG_TXT_ECHO_MODE                1          // echo mode for TXT peripheral
#define CONFIG_TXT_KBUF_SIZE                512        // kernel buffer for TXT write

#define CONFIG_FBF_WIDTH                    128
#define CONFIG_FBF_HEIGHT                   128

#define CONFIG_CPU_CTX_SIZE                 256        // up to 64 uint32_t registers
#define CONFIG_FPU_CTX_SIZE                 256        // up to 32 uint64_t registers
#define CONFIG_NIC_CHBUF_DEPTH              1          // number of containers in NIC chbuf

////////////////////////////////////////////////////////////////////////////////////////////
//                            PROCESS MANAGEMENT       
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAX_PROCESS_PER_CLUSTER      128        // max number of owned process
#define CONFIG_PROCESS_FILE_MAX_NR          8          // max number of open files
#define CONFIG_PROCESS_MAX_CHILDREN         1024       // max number of children process
#define CONFIG_PROCESS_HEAP_MIN_SIZE        0x00010000 // user heap min size (bytes)
#define CONFIG_PROCESS_HEAP_MAX_SIZE        0x30000000 // user heap max size (bytes)
#define CONFIG_PROCESS_INIT_PATH            "/bin/user/init.elf"

////////////////////////////////////////////////////////////////////////////////////////////
//                            VIRTUAL FILE SYSTEM        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VFS_MAX_INODES               128        // max number of inodes per cluster
#define CONFIG_VFS_MAX_NAME_LENGTH          32         // dentry name max length (bytes)
#define CONFIG_VFS_MAX_PATH_LENGTH          256        // pathname max length (bytes)

#define CONFIG_VFS_ROOT_IS_FATFS            1          // root FS is FATFS if non zero
#define CONFIG_VFS_ROOT_IS_EX2FS            0          // root FS is EX2FS if non zero

////////////////////////////////////////////////////////////////////////////////////////////
//                                 LOCKS          
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RWLOCK_DELAY                 50       // iterations number ( ~ 200 cycles )

////////////////////////////////////////////////////////////////////////////////////////////
//                                  DQDT        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DQDT_LEVELS_NR               5
#define CONFIG_DQDT_TICKS_PER_QUANTUM       1        // number of ticks between updates

////////////////////////////////////////////////////////////////////////////////////////////
//                              RANDOM NUMBERS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RDNG_PARAM_A                 65519
#define CONFIG_RDNG_PARAM_C                 64037

////////////////////////////////////////////////////////////////////////////////////////////
//                                SCHEDULING 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_SCHED_TICK_MS_PERIOD         10000   // number of milliseconds per period
#define CONFIG_SCHED_TICKS_PER_QUANTUM      1       // number of ticks between scheduling
#define CONFIG_SCHED_MAX_THREADS_NR         32      // max number of threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//                                 THREADS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_THREAD_MAX_PER_CLUSTER       16      // max threads per cluster & process
#define CONFIG_THREAD_DESC_SIZE             0x4000  // thread desc size (with kernel stack)
#define CONFIG_THREAD_DESC_ORDER            2       // ln( number of 4K pages )
#define CONFIG_THREAD_IDLE_MODE_SLEEP       false   // idle thread enter sleep mode 

////////////////////////////////////////////////////////////////////////////////////////////
//                             REMOTE PROCEDURE CALL
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_REMOTE_FIFO_SLOTS		    16
#define CONFIG_REMOTE_FIFO_MAX_ITERATIONS   1024
#define CONFIG_RPC_THREADS_MAX              4      // max number of RPC threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//                                  MAPPER
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAPPER_MAX_FRAGMENTS        10      // max number of fragments moved 
#define CONFIG_MAPPER_MIN                  CONFIG_VFS_INODE_MIN
#define CONFIG_MAPPER_MAX                  CONFIG_VFS_INODE_MAX

////////////////////////////////////////////////////////////////////////////////////////////
//                USER SPACE SEGMENTATION / all values are number of pages
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VMM_VSPACE_SIZE        0x100000     // virtual space          : 4   Gbytes

#define CONFIG_VMM_KENTRY_BASE        0x000004     // UTILS zone base        : 16  Kbytes
#define CONFIG_VMM_ELF_BASE           0x000400     // ELF zone base          : 4   Mbytes
#define CONFIG_VMM_HEAP_BASE          0x002000     // HEAP zone base         : 32  Mbytes
#define CONFIG_VMM_STACK_BASE         0x0F0000     // STACK zone base        : 3.7 Gbytes

#define CONFIG_VMM_KENTRY_SIZE        0x000004     // kentry vseg size       : 16  Kbytes
#define CONFIG_VMM_ARGS_SIZE          0x000004     // args vseg size         : 16  Kbytes
#define CONFIG_VMM_ENVS_SIZE          0x000008     // envs vseg size         : 32  Kbytes
#define CONFIG_VMM_STACK_SIZE         0x000100     // single stack vseg size : 1   Mbytes

#define CONFIG_VMM_GRDXT_W1           7            // number of bits for RADIX_TREE_IX1
#define CONFIG_VMM_GRDXT_W2           7            // number of bits for RADIX_TREE_IX2
#define CONFIG_VMM_GRDXT_W3           6            // number of bits for RADIX_TREE_IX3

////////////////////////////////////////////////////////////////////////////////////////////
//     PHYSICAL MEMORY MANAGEMENT (GENERIC)        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_PPM_PAGE_SIZE          4096         // physical page size (bytes)
#define CONFIG_PPM_PAGE_SHIFT         12           // physical page shift (bits)
#define CONFIG_PPM_PAGE_MASK          0x00000FFF   // physical page mask     
#define CONFIG_PPM_MAX_ORDER          16           // ln(total number of pages per cluster)
#define CONFIG_PPM_HEAP_ORDER         10           // ln(number of heap pages per cluster)
#define CONFIG_PPM_MAX_RSVD           32           // max reserved zones on the machine

#define CONFIG_KCM_SLOT_SIZE          64           // smallest allocated block (bytes)

#define CONFIG_PPM_PAGE_ALIGNED       __attribute__((aligned(CONFIG_PPM_PAGE_SIZE)))



////////////////////////////////////////////////////////////////////////////////////////////
//    deprecated
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DMA_RQ_KCM_MIN         2
#define CONFIG_DMA_RQ_KCM_MAX         4
#define CONFIG_TASK_KCM_MIN           2
#define CONFIG_TASK_KCM_MAX           3
#define CONFIG_FDINFO_KCM_MIN         2
#define CONFIG_FDINFO_KCM_MAX         2
#define CONFIG_DEVFS_CTX_MIN          1
#define CONFIG_DEVFS_CTX_MAX          1
#define CONFIG_DEVFS_FILE_MIN         2
#define CONFIG_DEVFS_FILE_MAX         3
#define CONFIG_DEVFS_NODE_MIN         1
#define CONFIG_DEVFS_NODE_MAX         2
#define CONFIG_VFAT_CTX_MIN           1
#define CONFIG_VFAT_CTX_MAX           1

#define CONFIG_RAMFS_FILE_MIN         3
#define CONFIG_RAMFS_FILE_MAX	      3

#define CONFIG_VFAT_FILE_MIN          3
#define CONFIG_VFAT_FILE_MAX          3
#define CONFIG_VFAT_NODE_MIN          2
#define CONFIG_VFAT_NODE_MAX          2

#define CONFIG_EXT2_CTX_MIN           1
#define CONFIG_EXT2_CTX_MAX           1
#define CONFIG_EXT2_FILE_MIN          3
#define CONFIG_EXT2_FILE_MAX          3
#define CONFIG_EXT2_NODE_MIN          2
#define CONFIG_EXT2_NODE_MAX          2

#define CONFIG_VFS_CTX_MIN            1
#define CONFIG_VFS_CTX_MAX            1
#define CONFIG_VFS_INODE_MIN          3
#define CONFIG_VFS_INODE_MAX          6
#define CONFIG_VFS_FILE_MIN           3
#define CONFIG_VFS_FILE_MAX           5

#define CONFIG_SEMAPHORE_MIN          2
#define CONFIG_SEMAPHORE_MAX          2
#define CONFIG_CONDTION_VAR_MIN       2
#define CONFIG_CONDTION_VAR_MAX       2
#define CONFIG_BARRIER_MIN            2
#define CONFIG_BARRIER_MAX            2
#define CONFIG_RWLOCK_MIN             2
#define CONFIG_RWLOCK_MAX             2
#define CONFIG_WAITQUEUEDB_MAX        2
#define CONFIG_WAITQUEUEDB_MIN        2
#define CONFIG_RADIX_NODE_MIN         10         
#define CONFIG_RADIX_NODE_MAX         30
#define CONFIG_VM_REGION_MIN          1
#define CONFIG_VM_REGION_MAX          2
#define CONFIG_BLKIO_MIN              4
#define CONFIG_BLKIO_MAX              8
#define CONFIG_KEYREC_MIN             2
#define CONFIG_KEYREC_MAX             2



#endif	/* _KERNEL_CONFIG_H_ */
