/*
 * stdio.h - User level <stdio> library definition.
 * 
 * Author     Alain Greiner (2016,2017,2018)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _STDIO_H_
#define _STDIO_H_

/*********************************************************************************************
 * This file defines the user level, TXT related <stdio> library.
 * These functions call the read() and write() functions defined in the <unistd> library
 * to access the TXT terminal.
 ********************************************************************************************/


/*********************************************************************************************
 * This function writes a formated string to the standard "stdout" stream.
 *********************************************************************************************
 * @ returns number of characters written if success / returns -1 if failure.
 ********************************************************************************************/
int printf( const char * format, ... );

/*********************************************************************************************
 * This function writes one single character to the standard "stdout" stream.
 *********************************************************************************************
 * @ returns written character code if success / returns 0 (EOF) if failure.
 ********************************************************************************************/
int putchar( int c );

/*********************************************************************************************
 * This function returns one single character from the standard "stdin" stream.
 *********************************************************************************************
 * @ returns read character code if success / returns 0 (EOF) if failure.
 ********************************************************************************************/
int getchar();

/*********************************************************************************************
 * This function copies a formated string to a fixed size buffer. 
 * it includes the NUL terminating character. 
 * it cheks that the formated string fit in the buffer length.
 *********************************************************************************************
 * @ string    : pointer on target buffer.
 * @ length    : max bumber of characters in target buffer.
 * @ format    : formated string.
 * @ returns number of characters written if success / returns -1 if failure.
 ********************************************************************************************/
int snprintf( char         * string,
              unsigned int   length,
              const char   * format, ... );

#endif  // _STDIO_H_
