/*
 * hal_vmm.h - Generic Virtual Memory Manager initialisation
 *
 * Authors  Alain Greiner (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HAL_PPM_H_
#define _HAL_PPM_H_

#include <hal_kernel_types.h>
#include <boot_info.h>

/////////////////////////////////////////////////////////////////////////////////////////
//    Generic Virtual Memory Manager initialisation (implementation in hal_vmm.c)
//
// Any arch-specific implementation must implement this API.
/////////////////////////////////////////////////////////////////////////////////////////

/****  Forward declarations  ****/

struct vmm_s;

/****************************************************************************************
 * This function makes all architecture specific initialisations
 * in the VSL (Virtual segments List) and in the GPT (Generic Page Table). 
 ****************************************************************************************
 * @ vmm   : pointer on virtual memory manager.
 * @ return 0 if success / return ENOMEM if failure.
 ***************************************************************************************/
error_t hal_vmm_init( struct vmm_s * vmm );

#endif	/* HAL_PPM_H_ */
