/*
 * shared_pthread.h - Shared structures and mnemonics used by the pthread related syscalls.
 *
 * Author  Alain Greiner (2016,2017,2018)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SHARED_PTHREAD_H_
#define _SHARED_PTHREAD_H_

/*******************************************************************************************
 * These typedef define the POSIX thread related types. 
 ******************************************************************************************/

typedef unsigned int      pthread_cond_t;
typedef unsigned int      pthread_condattr_t;
typedef unsigned int      pthread_rwlock_t;
typedef unsigned int      pthread_rwlockattr_t;
typedef unsigned int      pthread_key_t;

/*******************************************************************************************
 * This structure and enum define the attributes for the pthread_create() syscall.
 ******************************************************************************************/

typedef unsigned int  pthread_t;               

typedef struct pthread_attr_s
{
	unsigned int      attributes;      /*! user defined attributes bit vector             */
	unsigned int      cxy;             /*! target cluster identifier                      */
	unsigned int      lid;             /*! target core local index                        */
}
pthread_attr_t;

enum
{
    PT_ATTR_DETACH          = 0x0001,  /*! user defined not joinable                      */
    PT_ATTR_CLUSTER_DEFINED = 0x0002,  /*! user defined target cluster                    */
    PT_ATTR_CORE_DEFINED    = 0x0004,  /*! user defined core index in cluster             */
};

/******************************************************************************************* 
 * This enum defines the operation mnemonics for operations on POSIX condition variables.
 ******************************************************************************************/

typedef enum
{
	CONDVAR_INIT,
	CONDVAR_DESTROY,
    CONDVAR_WAIT,
    CONDVAR_SIGNAL,
    CONDVAR_BROADCAST,
} 
condvar_operation_t;

/******************************************************************************************* 
 * This enum defines the operation mnemonics for operations on POSIX barriers.
 ******************************************************************************************/

typedef enum
{
	BARRIER_INIT,
	BARRIER_DESTROY,
	BARRIER_WAIT,
} 
barrier_operation_t;

/******************************************************************************************* 
 * This enum defines the operation mnemonics for operations on POSIX mutex.
 ******************************************************************************************/

typedef enum
{
	MUTEX_INIT,
	MUTEX_DESTROY,
	MUTEX_LOCK,
	MUTEX_UNLOCK,
} 
mutex_operation_t;



#endif  // _PTHREAD_H_
