/****************************************************************************
* Define the base address for user code (both .text and .data)
*****************************************************************************/

seg_code_base      = 0x400000;

/***************************************************************************
* Define code entry point (e_entry field in .elf file)
***************************************************************************/

ENTRY( main )

/***************************************************************************
* Merge sections into segments for code and data
***************************************************************************/

SECTIONS
{
    . = seg_code_base;
    seg_code : 
    {
        *(.text)
        *(.text.*)
    }

	. = ALIGN(0x1000);

    seg_data : 
    {
        *(.ctors)
        *(.rodata)
        *(.rodata.*)
        *(.data)
        *(.lit8)
        *(.lit4)
        *(.sdata)
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
    }
}

