/*
 * hal_kentry.h - General values used in the different kernel entries
 * 
 * Copyright (c) 2017 Maxime Villard
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#define	T_PRIVINFLT	 0	/* privileged instruction */
#define	T_BPTFLT	 1	/* breakpoint trap */
#define	T_ARITHTRAP	 2	/* arithmetic trap */
#define	T_ASTFLT	 3	/* asynchronous system trap */
#define	T_PROTFLT	 4	/* protection fault */
#define	T_TRCTRAP	 5	/* trace trap */
#define	T_PAGEFLT	 6	/* page fault */
#define	T_ALIGNFLT	 7	/* alignment fault */
#define	T_DIVIDE	 8	/* integer divide fault */
#define	T_NMI		 9	/* non-maskable interrupt */
#define	T_OFLOW		10	/* overflow trap */
#define	T_BOUND		11	/* bounds check fault */
#define	T_DNA		12	/* device not available fault */
#define	T_DOUBLEFLT	13	/* double fault */
#define	T_FPOPFLT	14	/* fp coprocessor operand fetch fault */
#define	T_TSSFLT	15	/* invalid tss fault */
#define	T_SEGNPFLT	16	/* segment not present fault */
#define	T_STKFLT	17	/* stack fault */
#define	T_MCA		18	/* machine check */
#define T_XMM		19	/* SSE FP exception */
#define T_RESERVED	20	/* reserved fault base */

/* Trap's coming from user mode */
#define	T_USER	0x100

#ifndef x86_ASM

/*
 * The x86_64 trap frame.
 */
struct trapframe {
	uint64_t tf_rdi;
	uint64_t tf_rsi;
	uint64_t tf_rdx;
	uint64_t tf_r10;
	uint64_t tf_r8;
	uint64_t tf_r9;

	uint64_t tf_arg6;
	uint64_t tf_arg7;
	uint64_t tf_arg8;
	uint64_t tf_arg9;

	uint64_t tf_rcx;
	uint64_t tf_r11;
	uint64_t tf_r12;
	uint64_t tf_r13;
	uint64_t tf_r14;
	uint64_t tf_r15;
	uint64_t tf_rbp;
	uint64_t tf_rbx;
	uint64_t tf_rax;

	uint64_t tf_gs;
	uint64_t tf_fs;
	uint64_t tf_es;
	uint64_t tf_ds;

	uint64_t tf_trapno;

	/* These are pushed for a trap */
	uint64_t tf_err;
	uint64_t tf_rip;
	uint64_t tf_cs;
	uint64_t tf_rflags;

	/* These are always pushed */
	uint64_t tf_rsp;
	uint64_t tf_ss;
};

/*
 * Our small trap frame.
 */
struct small_trapframe {
	uint64_t tf_trapno;

	/* These are pushed for a trap */
	uint64_t tf_err;
	uint64_t tf_rip;
	uint64_t tf_cs;
	uint64_t tf_rflags;

	/* These are always pushed */
	uint64_t tf_rsp;
	uint64_t tf_ss;
};

#endif

