/*
 * kernel_config.h - global kernel configuration arguments
 * 
 * Authors  Ghassan Almaless (2008,2009,2010,2011,2012) 
 *          Mohamed Lamine Karaoui (2015)
 *          Alain Greiner (2016)
 *
 * Copyright (c)  UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _ALMOS_CONFIG_H_
#define _ALMOS_CONFIG_H_

#define CONFIG_ALMOS_VERSION                "Version 1.0 / March 2017"

////////////////////////////////////////////////////////////////////////////////////////////
//        HARDWARE CONFIGURATION     
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_KERNEL_IDENTITY              true       // True for 32 bits cores             
#define CONFIG_CYCLES_PER_MS                1000000    // about 1 Ghz             
#define CONFIG_MAX_CLUSTER                  256        // max number of clusters
#define CONFIG_MAX_CORES_PER_CLUSTER        4          // max number of cores per cluster
#define CONFIG_MAX_DEVICES_PER_CLUSTER      32         // max number of periphs per cluster 
#define CONFIG_MAX_HWIS_PER_ICU             32         // max number of HWI per ICU
#define CONFIG_MAX_PTIS_PER_ICU             32         // max number of PTI per ICU
#define CONFIG_MAX_WTIS_PER_ICU             32         // max number of WTI per ICU
#define CONFIG_MAX_IRQS_PER_PIC             32         // max number of input IRQs in PIC 
#define CONFIG_IRQS_PER_CORE                4          // number of input IRQs per core
#define CONFIG_CLUSTER_SPAN                 32         // ln(phys. address space per cluster)
#define CONFIG_CACHE_LINE_SIZE              64         // number of bytes in cache line

#define CONFIG_MAX_TXT_CHANNELS             32         // max number of TXT device channels
#define CONFIG_MAX_NIC_CHANNELS             32         // max number of NIC device channels
#define CONFIG_MAX_CMA_CHANNELS             32         // max number of CMA device channels
#define CONFIG_MAX_CLUSTERS                 256        // max number of clusters

#define CONFIG_TXT_ECHO_MODE                1          // echo mode for TXT peripheral

#define CONFIG_NIC_CHBUF_DEPTH              1          // number of containers in NIC chbuf

////////////////////////////////////////////////////////////////////////////////////////////
//      PROCESS MANAGEMENT       
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAX_PROCESS_PER_CLUSTER      128        // max number of owned process
#define CONFIG_PROCESS_MAX_NR_POW           10         // TODO ??? [AG]
#define CONFIG_PROCESS_FILE_MAX_NR          8          // max number of open files
#define CONFIG_PROCESS_CHILDS_MAX_NR        1024       // max number of childs process
#define CONFIG_PROCESS_ARGS_PAGES_MAX_NR    4          // TODO ??? [AG]
#define CONFIG_PROCESS_HEAP_MIN_SIZE        0x00010000 // user heap min size (bytes)
#define CONFIG_PROCESS_HEAP_MAX_SIZE        0x30000000 // user heap max size (bytes)

////////////////////////////////////////////////////////////////////////////////////////////
//          VIRTUAL FILE SYSTEM        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VFS_MAX_INODES               128        // max number of inodes per cluster
#define CONFIG_VFS_MAX_NAME_LENGTH          256        // dentry name max length (bytes)
#define CONFIG_VFS_MAX_PATH_LENGTH          1024       // pathname max length (bytes)

#define CONFIG_ROOTFS_IS_EXT2               0
#define CONFIG_ROOTFS_IS_VFAT               1

////////////////////////////////////////////////////////////////////////////////////////////
//          MISCELANEOUS        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_CORE_CHECK_EVERY		        2000
#define CONFIG_DEV_VERSION                  yes
#define CONFIG_USE_COA                      yes
#define CONFIG_EXEC_LOCAL                   no
#define CONFIG_USE_KEYSDB                   yes
#define CONFIG_SHOW_BOOT_BANNER             yes
#define CONFIG_MAX_CLUSTER_ROOT             16
#define CONFIG_GLOBAL_CLUSTERS_ORDER        0
#define CONFIG_GLOBAL_CORES_ORDER           0
#define CONFIG_MAX_DQDT_DEPTH               4
#define CONFIG_USE_DQDT                     no
#define CONFIG_CORE_BALANCING_PERIOD        4
#define CONFIG_CORE_LOAD_PERIOD             4
#define CONFIG_CLUSTER_KEYS_NR              8
#define CONFIG_REL_KFIFO_SIZE               32

////////////////////////////////////////////////////////////////////////////////////////////
//          LOCKS          
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RWLOCK_DELAY                 50     // number of iterations => 200 cycles

////////////////////////////////////////////////////////////////////////////////////////////
//          DQDT           
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DQDT_LEVELS_NR               5
#define CONFIG_DQDT_PERIOD                  1      // number of ticks between updates

////////////////////////////////////////////////////////////////////////////////////////////
//          RANDOM NUMBERS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RDNG_PARAM_A                 65519
#define CONFIG_RDNG_PARAM_C                 64037

////////////////////////////////////////////////////////////////////////////////////////////
//          SCHEDULING 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_SCHED_TICK_PERIOD            50000 // number of cycles
#define CONFIG_SCHED_MAX_THREADS_NR         32    // max number of threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//          THREADS 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_THREAD_MAX_PER_CLUSTER      16     // max number of user threads per cluster
#define CONFIG_THREAD_PAGE_ORDER           1      // ln( number of pages for thread_t )

////////////////////////////////////////////////////////////////////////////////////////////
//          REMOTE_FIFO 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_REMOTE_FIFO_SLOTS		    256
#define CONFIG_REMOTE_FIFO_ITERATION_DELAY  1024
#define CONFIG_REMOTE_FIFO_MAX_ITERATIONS   1024

////////////////////////////////////////////////////////////////////////////////////////////
//          REMOTE PROCEDURE CALL
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_RPC_PENDING_MAX              8     // max requests handled by one server 
#define CONFIG_RPC_THREADS_MAX              8     // max number of RPC threads per core

////////////////////////////////////////////////////////////////////////////////////////////
//         USER APPLICATION STDIO
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DEV_STDIN           "/dev/tty2"
#define CONFIG_DEV_STDOUT          "/dev/tty2"
#define CONFIG_DEV_STDERR          "/dev/tty3"

////////////////////////////////////////////////////////////////////////////////////////////
//          MAPPER
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_MAPPER_MAX_FRAGMENTS        10    // max number of fragments moved 
#define CONFIG_MAPPER_MIN             CONFIG_VFS_INODE_MIN
#define CONFIG_MAPPER_MAX             CONFIG_VFS_INODE_MAX

////////////////////////////////////////////////////////////////////////////////////////////
//      USER SPACE SEGMENTATION (all values are number of pages)
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_VMM_VSPACE_SIZE        0x100000     // virtual space           : 4   Gbytes

#define CONFIG_VMM_ELF_BASE           0x000100     // ELF zone base           : 1   Mbytes
#define CONFIG_VMM_HEAP_BASE          0x000400     // HEAP zone base          : 4   Mbytes
#define CONFIG_VMM_MMAP_BASE          0x040000     // MMAP zone base          : 1   Gbytes
#define CONFIG_VMM_STACK_BASE         0x0C0000     // STACK zone base         : 3   Gbytes

#define CONFIG_VMM_KENTRY_SIZE        0x000004     // kentry vseg size        : 16  Kbytes
#define CONFIG_VMM_ARGS_SIZE          0x000004     // args vseg size          : 16  Kbytes
#define CONFIG_VMM_ENVS_SIZE          0x000008     // envs vseg size          : 32  Kbytes
#define CONFIG_VMM_STACK_SIZE         0x001FFF     // single stack vseg size  : 32  Mbytes
#define CONFIG_VMM_HEAP_SIZE          0x010000     // shared heap  vseg size  : 256 Mbytes

#define CONFIG_VMM_GRDXT_W1           7            // number of bits for RADIX_TREE_IX1
#define CONFIG_VMM_GRDXT_W2           7            // number of bits for RADIX_TREE_IX2
#define CONFIG_VMM_GRDXT_W3           6            // number of bits for RADIX_TREE_IX3

////////////////////////////////////////////////////////////////////////////////////////////
//     PHYSICAL MEMORY MANAGEMENT        
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_PPM_PAGE_SIZE          4096         // physical page size (bytes)
#define CONFIG_PPM_PAGE_SHIFT         12           // physical page shift (bits)
#define CONFIG_PPM_PAGE_MASK          0x00000FFF   // physical page mask     
#define CONFIG_PPM_MAX_ORDER          16           // ln(total number of pages per cluster)
#define CONFIG_PPM_HEAP_ORDER         10           // ln(number of heap pages per cluster)

////////////////////////////////////////////////////////////////////////////////////////////
//          KERNEL DEBUG 
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_DMSG_LEVEL                DMSG_DEBUG
#define CONFIG_XICU_USR_ACCESS           no
#define CONFIG_SPINLOCK_CHECK            no
#define CONFIG_SPINLOCK_TIMEOUT          100
#define CONFIG_ENABLE_TASK_TRACE         no
#define CONFIG_ENABLE_THREAD_TRACE       no
#define CONFIG_SHOW_PAGEFAULT            no
#define CONFIG_SHOW_CORE_USAGE           no
#define CONFIG_SHOW_CORE_IPI_MSG         no
#define CONFIG_SHOW_FPU_MSG              no
#define CONFIG_SHOW_THREAD_MSG           no
#define CONFIG_SHOW_PPM_PGALLOC_MSG      no
#define CONFIG_SHOW_VMM_LOOKUP_TM        no
#define CONFIG_SHOW_VMM_ERROR_MSG        no
#define CONFIG_SHOW_SPURIOUS_PGFAULT     no
#define CONFIG_SHOW_MIGRATE_MSG          no
#define CONFIG_SHOW_VMMMGRT_MSG          no
#define CONFIG_SHOW_SYSMGRT_MSG          no
#define CONFIG_SHOW_REMOTE_PGALLOC       no
#define CONFIG_SHOW_LOCAL_EVENTS         no
#define CONFIG_SHOW_SIG_MSG              no
#define CONFIG_SCHED_SHOW_NOTIFICATIONS  no
#define CONFIG_SHOW_EPC_CORE0            no
#define CONFIG_CORE_TRACE                no
#define CONFIG_DQDT_DEBUG                no
#define CONFIG_KFIFO_DEBUG               no
#define CONFIG_KHM_DEBUG                 no
#define CONFIG_KCM_DEBUG                 no
#define CONFIG_KMEM_DEBUG                no
#define CONFIG_MAPPER_DEBUG              no
#define CONFIG_SHOW_KMEM_INIT            no
#define CONFIG_MEM_CHECK                 no
#define CONFIG_THREAD_TIME_STAT          yes
#define CONFIG_SCHED_RR_CHECK            no
#define CONFIG_FORK_DEBUG                no//yes
#define CONFIG_VMM_DEBUG                 no
#define CONFIG_ELF_DEBUG                 no
#define CONFIG_VFAT_PGWRITE_ENABLE       no
#define CONFIG_VFAT_DEBUG                no
#define CONFIG_VFAT_INSTRUMENT           no
#define CONFIG_EXT2_DEBUG                no
#define CONFIG_METAFS_DEBUG              no
#define CONFIG_VFS_DEBUG                 no
#define CONFIG_VFS_INODE_LOCAL           yes
#define CONFIG_DEVFS_DEBUG               no
#define CONFIG_SYSFS_DEBUG               no
#define CONFIG_BLKIO_DEBUG               no
#define CONFIG_BC_DEBUG                  no
#define CONFIG_BC_INSTRUMENT             no
#define CONFIG_LOCKS_DEBUG               no
#define CONFIG_SCHED_DEBUG               no
#define CONFIG_VERBOSE_LOCK              no
#define CONFIG_PID_DEBUG                 no//yes
#define CONFIG_HTBL_DEBUG                no
#define CONFIG_SHOW_RPC_MSG              no
#define CONFIG_EXEC_DEBUG                no
#define CONFIG_USE_RPC_TEST              yes
#define CONFIG_SHOW_ALL_BOOT_MSG         no//yes
#define CONFIG_ALMOS_LIST_DEBUG		     no
////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////
//     SYSFS                             
////////////////////////////////////////////////////////////////////////////////////////////

#define CONFIG_SYSFS_FILE_MIN         1
#define CONFIG_SYSFS_FILE_MAX         2
#define CONFIG_SYSFS_NODE_MIN         1
#define CONFIG_SYSFS_NODE_MAX         2
#define CONFIG_SYSFS_NAME_LEN         12           // maximum supported name length
#define CONFIG_SYSFS_BUFFER_SIZE      256          // maximum supported output size 


#define CONFIG_DMA_RQ_KCM_MIN         2
#define CONFIG_DMA_RQ_KCM_MAX         4
#define CONFIG_TASK_KCM_MIN           2
#define CONFIG_TASK_KCM_MAX           3
#define CONFIG_FDINFO_KCM_MIN         2
#define CONFIG_FDINFO_KCM_MAX         2
#define CONFIG_DEVFS_CTX_MIN          1
#define CONFIG_DEVFS_CTX_MAX          1
#define CONFIG_DEVFS_FILE_MIN         2
#define CONFIG_DEVFS_FILE_MAX         3
#define CONFIG_DEVFS_NODE_MIN         1
#define CONFIG_DEVFS_NODE_MAX         2
#define CONFIG_VFAT_CTX_MIN           1
#define CONFIG_VFAT_CTX_MAX           1

#define CONFIG_RAMFS_FILE_MIN         3
#define CONFIG_RAMFS_FILE_MAX	      3

#define CONFIG_VFAT_FILE_MIN          3
#define CONFIG_VFAT_FILE_MAX          3
#define CONFIG_VFAT_NODE_MIN          2
#define CONFIG_VFAT_NODE_MAX          2

#define CONFIG_EXT2_CTX_MIN           1
#define CONFIG_EXT2_CTX_MAX           1
#define CONFIG_EXT2_FILE_MIN          3
#define CONFIG_EXT2_FILE_MAX          3
#define CONFIG_EXT2_NODE_MIN          2
#define CONFIG_EXT2_NODE_MAX          2

#define CONFIG_VFS_CTX_MIN            1
#define CONFIG_VFS_CTX_MAX            1
#define CONFIG_VFS_INODE_MIN          3
#define CONFIG_VFS_INODE_MAX          6
#define CONFIG_VFS_FILE_MIN           3
#define CONFIG_VFS_FILE_MAX           5

#define CONFIG_SEMAPHORE_MIN          2
#define CONFIG_SEMAPHORE_MAX          2
#define CONFIG_CONDTION_VAR_MIN       2
#define CONFIG_CONDTION_VAR_MAX       2
#define CONFIG_BARRIER_MIN            2
#define CONFIG_BARRIER_MAX            2
#define CONFIG_RWLOCK_MIN             2
#define CONFIG_RWLOCK_MAX             2
#define CONFIG_WAITQUEUEDB_MAX        2
#define CONFIG_WAITQUEUEDB_MIN        2
#define CONFIG_RADIX_NODE_MIN         10         
#define CONFIG_RADIX_NODE_MAX         30
#define CONFIG_VM_REGION_MIN          1
#define CONFIG_VM_REGION_MAX          2
#define CONFIG_BLKIO_MIN              4
#define CONFIG_BLKIO_MAX              8
#define CONFIG_KEYREC_MIN             2
#define CONFIG_KEYREC_MAX             2



#endif	/* _KERNEL_CONFIG_H_ */
