/*
 * ramfs.c  RAMFS file system API implementation.
 *
 * Authors   Mohamed Lamine Karaoui (2015)
 *           Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */


#include <hal_types.h>
#include <hal_special.h>
#include <printk.h>
#include <kmem.h>
#include <vfs.h>
#include <ramfs.h>


///////////////////////////////////////////////////////////////////////////////////////
// RAMFS specific functions : these static functions cannot be called by the VFS 
///////////////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////////////
// Generic API : the following functions are called by the VFS, 
//               and must be defined by all supported file systems.
///////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
error_t ramfs_inode_create( struct vfs_inode_s * vfs_inode )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();

    kmem_req_t      req;
    error_t         error;
    ramfs_inode_t * ramfs_inode;

    // allocate memory for ramfs inode
	req.type    = KMEM_RAMFS_INODE;
	req.size    = sizeof(ramfs_inode_t);
    req.flags   = AF_KERNEL | AF_ZERO;
	ramfs_inode = (ramfs_inode_t *)kmem_alloc( &req );

    if( ramfs_inode == NULL ) return ENOMEM;

    // initialise ramfs_inode TODO

    // link vfs_inode to ramfs_inode
    inode->extend    = ramfs_inode;
    ramfs->vfs_inode = vfs_inode;

    return 0;
}

//////////////////////////////////////////////////////
void ramfs_inode_destroy( struct vfs_inode_s * inode )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();
}

/////////////////////////////////////////////////
error_t ramfs_write_page( struct page_s  * page )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();
}

////////////////////////////////////////////////
error_t ramfs_read_page( struct page_s  * page )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();
}
   
