/* Copyright (c) 2002 Red Hat Incorporated.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

     Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

     Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

     The name of Red Hat Incorporated may not be used to endorse
     or promote products derived from this software without specific
     prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL RED HAT INCORPORATED BE LIABLE FOR ANY
   DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS   
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/* Generated using UnicodeData.txt 5.2 */

/* Expression used to filter out the characters for the below tables:

   awk -F\; \
   '{ \
     VAL = strtonum (sprintf("0x%s", $1)); \
     # All valid characters except from categories Cc (C0 or C1 control code), \
     # Cs (Surrogates), Zl (Line separator), and Zp (Paragraph separator).\
     # \
     # Before running this test, make sure to expand all Unicode blocks \
     # which are just marked by their first and last character! \
     # \
     if (!match($3, "^C[cs]") && !match($3, "^Z[lp]")) \
       print $1; \
   }' UnicodeData.txt
*/
static const unsigned char u0[] = {
  0x20, 0x0, 0x7e, 0xa0, 0x0, 0xff };
/* u1 is all-print */
/* u2 is all-print */
static const unsigned char u3[] = { 
  0x00, 0x0, 0x77, 0x7a, 0x0, 0x7e,
  0x84, 0x0, 0x8a, 0x8c, 0x8e, 0x0, 
  0xa1, 0xa3, 0x0, 0xff };
/* u4 is all-print */
static const unsigned char u5[] = {
  0x00, 0x0, 0x25, 0x31, 0x0, 
  0x56, 0x59, 0x0, 0x5f, 0x61, 0x0, 0x87, 0x89, 
  0x0, 0x8a, 0x91, 0x0, 0xc7, 0xd0, 0x0, 0xea,
  0xf0, 0x0, 0xf4 };
static const unsigned char u6[] = {
  0x00, 0x0, 0x03, 0x06, 0x0, 0x1b, 0x1e, 0x1f,
  0x21, 0x0, 0x5e, 0x60, 0x0, 0xff };
static const unsigned char u7[] = { 
  0x00, 0x0, 0x0d, 0x0f, 0x0, 0x4a, 0x4d, 0x0, 0xb1,
  0xc0, 0x0, 0xfa };
static const unsigned char u8[] = { 
  0x00, 0x0, 0x2d, 0x30, 0x0, 0x3e, };
static const unsigned char u9[] = {
  0x00, 0x0, 0x39, 0x3c, 0x0, 0x4e, 0x50, 0x0, 0x55, 
  0x58, 0x0, 0x72, 0x79, 0x0, 0x7f, 0x81, 0x0, 0x83,
  0x85, 0x0, 0x8c, 0x8f, 0x0, 0x90, 0x93, 0x0, 0xa8,
  0xaa, 0x0, 0xb0, 0xb2, 0xb6, 0x0, 0xb9, 0xbc, 
  0x0, 0xc4, 0xc7, 0xc8, 0xcb, 0x0, 0xce, 
  0xd7, 0xdc, 0x0, 0xdd, 0xdf, 0x0, 0xe3, 0xe6, 
  0x0, 0xfb };
static const unsigned char ua[] = { 
  0x01, 0x0, 0x03, 0x05, 0x0, 0x0a, 0x0f, 0x0, 
  0x10, 0x13, 0x0, 0x28, 0x2a, 0x0, 0x30, 0x32, 
  0x0, 0x33, 0x35, 0x0, 0x36, 0x38, 0x0, 0x39, 
  0x3c, 0x3e, 0x0, 0x42, 0x47, 0x0, 0x48, 0x4b, 
  0x0, 0x4d, 0x51, 0x59, 0x0, 0x5c, 0x5e, 0x66, 0x0, 
  0x75, 0x81, 0x0, 0x83, 0x85, 0x0, 0x8d,
  0x8f, 0x0, 0x91, 0x93, 0x0, 0xa8, 0xaa, 0x0, 
  0xb0, 0xb2, 0x0, 0xb3, 0xb5, 0x0, 0xb9, 0xbc, 
  0x0, 0xc5, 0xc7, 0x0, 0xc9, 0xcb, 0x0, 0xcd, 
  0xd0, 0xe0, 0x0, 0xe3, 0xe6, 0x0, 0xef, 0xf1 };
static const unsigned char ub[] = {
  0x01, 0x0, 0x03, 
  0x05, 0x0, 0x0c, 0x0f, 0x0, 0x10, 0x13, 0x0, 
  0x28, 0x2a, 0x0, 0x30, 0x32, 0x0, 0x33, 0x35, 
  0x0, 0x39, 0x3c, 0x0, 0x44, 0x47, 0x0, 0x48, 
  0x4b, 0x0, 0x4d, 0x56, 0x0, 0x57, 0x5c, 0x0, 
  0x5d, 0x5f, 0x0, 0x63, 0x66, 0x0, 0x71, 0x82, 
  0x0, 0x83, 0x85, 0x0, 0x8a, 0x8e, 0x0, 0x90, 
  0x92, 0x0, 0x95, 0x99, 0x0, 0x9a, 0x9c, 0x9e, 
  0x0, 0x9f, 0xa3, 0x0, 0xa4, 0xa8, 0x0, 0xaa, 
  0xae, 0x0, 0xb9, 0xbe, 0x0, 
  0xc2, 0xc6, 0x0, 0xc8, 0xca, 0x0, 0xcd, 0xd0,
  0xd7, 0xe6, 0xe7, 0x0, 0xfa };
static const unsigned char uc[] = {
  0x01, 0x0, 0x03, 0x05, 0x0, 
  0x0c, 0x0e, 0x0, 0x10, 0x12, 0x0, 0x28, 0x2a, 
  0x0, 0x33, 0x35, 0x0, 0x39, 0x3d, 0x0, 0x44, 
  0x46, 0x0, 0x48, 0x4a, 0x0, 0x4d, 0x55, 0x0, 
  0x56, 0x58, 0x59, 0x60, 0x0, 0x63, 0x66, 0x0, 0x6f,
  0x78, 0x0, 0x7f, 0x82, 0x83, 0x85, 0x0, 0x8c,
  0x8e, 0x0, 0x90, 0x92, 0x0, 0xa8, 0xaa, 0x0, 0xb3,
  0xb5, 0x0, 0xb9, 0xbc, 0x0, 0xc4, 0xc6, 0x0, 0xc8,
  0xca, 0x0, 0xcd, 0xd5, 0x0, 0xd6, 0xde, 0xe0, 0x0, 
  0xe3, 0xe6, 0x0, 0xef, 0xf1, 0xf2 };
static const unsigned char ud[] = {
  0x02, 0x0, 0x03, 0x05, 
  0x0, 0x0c, 0x0e, 0x0, 0x10, 0x12, 0x0, 0x28, 
  0x2a, 0x0, 0x39, 0x3d, 0x0, 0x44, 0x46, 0x0, 
  0x48, 0x4a, 0x0, 0x4d, 0x57, 0x60, 0x0, 0x63, 
  0x66, 0x0, 0x75, 0x79, 0x0, 0x7f, 0x82, 0x0, 0x83,
  0x85, 0x0, 0x96, 0x9a, 0x0, 0xb1, 0xb3, 0x0, 0xbb,
  0xbd, 0xc0, 0x0, 0xc6, 0xca, 0xcf, 0x0, 0xd4, 0xd6, 
  0xd8, 0x0, 0xdf, 0xf2, 0x0, 0xf4 };
static const unsigned char ue[] = {
  0x01, 0x0, 
  0x3a, 0x3f, 0x0, 0x5b, 0x81, 0x0, 0x82, 0x84, 
  0x87, 0x0, 0x88, 0x8a, 0x8d, 0x94, 0x0, 0x97, 
  0x99, 0x0, 0x9f, 0xa1, 0x0, 0xa3, 0xa5, 0xa7, 
  0xaa, 0x0, 0xab, 0xad, 0x0, 0xb9, 0xbb, 0x0, 
  0xbd, 0xc0, 0x0, 0xc4, 0xc6, 0xc8, 0x0, 0xcd, 
  0xd0, 0x0, 0xd9, 0xdc, 0x0, 0xdd };
static const unsigned char uf[] = {
  0x00, 0x0, 0x47, 0x49, 0x0, 0x6c,
  0x71, 0x0, 0x8b, 0x90, 0x0, 0x97,
  0x99, 0x0, 0xbc, 0xbe, 0x0, 0xcc, 
  0xce, 0x0, 0xd8 };
static const unsigned char u10[] = {
  0x00, 0x0, 0xc5, 0xd0, 0x0, 0xfc };
/* u11 is all-print */
static const unsigned char u12[] = {
  0x00, 0x0, 0x48, 0x4a, 0x0, 0x4d, 0x50, 0x0, 0x56, 
  0x58, 0x5a, 0x0, 0x5d, 0x60, 0x0, 0x88, 
  0x8a, 0x0, 0x8d, 0x90, 0x0, 0xb0, 0xb2, 
  0x0, 0xb5, 0xb8, 0x0, 0xbe, 0xc0, 0xc2, 0x0, 
  0xc5, 0xc8, 0x0, 0xd6, 0xd8, 0x0, 0xff };
static const unsigned char u13[] = {
  0x00, 0x0, 0x10, 0x12, 0x0, 0x15,
  0x18, 0x0, 0x5a, 0x5f, 0x0, 0x7c,
  0x80, 0x0, 0x99, 0xa0, 0x0, 0xf4 };
/* u14 is all-print */
/* u15 is all-print */
static const unsigned char u16[] = {
  0x00, 0x0, 0x9c, 0xa0, 0x0, 0xf0 };
static const unsigned char u17[] = {
  0x00, 0x0, 0x0c, 0x0e, 0x0, 0x14, 0x20, 
  0x0, 0x36, 0x40, 0x0, 0x53, 0x60, 0x0, 0x6c, 
  0x6e, 0x0, 0x70, 0x72, 0x0, 0x73, 0x80, 0x0, 
  0xdd, 0xe0, 0x0, 0xe9, 0xf0, 0x0, 0xf9 };
static const unsigned char u18[] = {
  0x00, 0x0, 0x0e, 0x10, 
  0x0, 0x19, 0x20, 0x0, 0x77, 0x80, 0x0, 0xaa,
  0xb0, 0x0, 0xf5 };
static const unsigned char u19[] = {
  0x00, 0x0, 0x1c, 0x20, 0x0, 0x2b,
  0x30, 0x0, 0x3b, 0x40, 0x44, 0x0, 0x6d,
  0x70, 0x0, 0x74, 0x80, 0x0, 0xab,
  0xb0, 0x0, 0xc9, 0xd0, 0x0, 0xda,
  0xde, 0x0, 0xff };
static const unsigned char u1a[] = {
  0x00, 0x0, 0x1b, 0x1e, 0x0, 0x5e,
  0x60, 0x0, 0x7c, 0x7f, 0x0, 0x89,
  0x90, 0x0, 0x99, 0xa0, 0x0, 0xad };
static const unsigned char u1b[] = {
  0x00, 0x0, 0x4b, 0x50, 0x0, 0x7c,
  0x80, 0x0, 0xaa, 0xae, 0x0, 0xb9 };
static const unsigned char u1c[] = {
  0x00, 0x0, 0x37, 0x3b, 0x0, 0x49,
  0x4d, 0x0, 0x7f, 0xd0, 0x0, 0xf2 };
static const unsigned char u1d[] = { 
  0x00, 0x0, 0xe6, 0xfd, 0x0, 0xff };
/* u1e is all-print */
static const unsigned char u1f[] = {
  0x00, 0x0, 
  0x15, 0x18, 0x0, 0x1d, 0x20, 0x0, 0x45, 0x48, 
  0x0, 0x4d, 0x50, 0x0, 0x57, 0x59, 0x5b, 0x5d, 
  0x5f, 0x0, 0x7d, 0x80, 0x0, 0xb4, 0xb6, 0x0, 
  0xc4, 0xc6, 0x0, 0xd3, 0xd6, 0x0, 0xdb, 0xdd, 
  0x0, 0xef, 0xf2, 0x0, 0xf4, 0xf6, 0x0, 0xfe };
static const unsigned char u20[] = { 
  0x00, 0x0, 0x27, 0x2a, 0x0, 0x64,
  0x6a, 0x0, 0x71, 0x74, 0x0, 0x8e, 
  0x90, 0x0, 0x94, 0xa0, 0x0, 0xb8,
  0xd0, 0x0, 0xf0 };
static const unsigned char u21[] = {
  0x00, 0x0, 0x89, 0x90, 0x0, 0xff };
/* u22 is all-print */
static const unsigned char u23[] = {
  0x00, 0x0, 0xe8 };
static const unsigned char u24[] = {
  0x00, 0x0, 0x26, 0x40, 0x0, 0x4a, 
  0x60, 0x0, 0xff };
/* u25 is all-print */
static const unsigned char u26[] = {
  0x00, 0x0, 0xcd, 0xcf, 0x0, 0xe1,
  0xe3, 0xe8, 0x0, 0xff };
static const unsigned char u27[] = {
  0x01, 0x0, 0x04, 0x06, 0x0, 0x09,
  0x0c, 0x0, 0x27, 0x29, 0x0, 0x4b, 0x4d,
  0x4f, 0x0, 0x52, 0x56, 0x0, 0x5e,
  0x61, 0x0, 0x94, 0x98, 0x0, 0xaf,
  0xb1, 0x0, 0xbe, 0xc0, 0x0, 0xca, 0xcc,
  0xd0, 0x0, 0xff };
/* u28 to u2a are all-print */
static const unsigned char u2b[] = {
  0x00, 0x0, 0x4c, 0x50, 0x0, 0x59 };
static const unsigned char u2c[] = {
  0x00, 0x0, 0x2e, 0x30, 0x0, 0x5e,
  0x60, 0x0, 0xf1, 0xf9, 0x0, 0xff };
static const unsigned char u2d[] = {
  0x00, 0x0, 0x25, 0x30, 0x0, 0x65, 0x6f,
  0x80, 0x0, 0x96, 0xa0, 0x0, 0xa6,
  0xa8, 0x0, 0xae, 0xb0, 0x0, 0xb6,
  0xb8, 0x0, 0xbe, 0xc0, 0x0, 0xc6,
  0xc8, 0x0, 0xce, 0xd0, 0x0, 0xd6,
  0xd8, 0x0, 0xde, 0xe0, 0x0, 0xff };
static const unsigned char u2e[] = {
  0x00, 0x0, 0x31, 0x80, 0x0, 0x99,
  0x9b, 0x0, 0xf3 };
static const unsigned char u2f[] = { 
  0x00, 0x0, 0xd5, 0xf0, 0x0, 0xfb };
static const unsigned char u30[] = {
  0x00, 0x0, 
  0x3f, 0x41, 0x0, 0x96, 0x99, 0x0, 0xff };
static const unsigned char u31[] = {
  0x05, 0x0, 0x2d, 0x31, 0x0, 0x8e,
  0x90, 0x0, 0xb7, 0xc0, 0x0, 0xe3,
  0xf0, 0x0, 0xff };
static const unsigned char u32[] = {
  0x00, 0x0, 0x1e, 0x20, 0x0, 0xfe };
/* u33 to u4c is all-print */
static const unsigned char u4d[] = { 
  0x00, 0x0, 0xb5, 0xc0, 0x0, 0xff };
/* u4e to u9e is all-print */
static const unsigned char u9f[] = {
  0x00, 0x0, 0xcb };
/* ua0 to ua3 is all-print */
static const unsigned char ua4[] = {
  0x00, 0x0, 0x8c, 0x90, 0x0, 0xc6,
  0xd0, 0x0, 0xff };
/* ua5 is all-print */
static const unsigned char ua6[] = {
  0x00, 0x0, 0x2b, 0x40, 0x0, 0x5f,
  0x62, 0x0, 0x73, 0x7c, 0x0, 0x97,
  0xa0, 0x0, 0xf7 };
static const unsigned char ua7[] = {
  0x00, 0x0, 0x8c, 0xfb, 0x0, 0xff };
static const unsigned char ua8[] = {
  0x00, 0x0, 0x2b, 0x30, 0x0, 0x39,
  0x40, 0x0, 0x77, 0x80, 0x0, 0xc4,
  0xce, 0x0, 0xd9, 0xe0, 0x0, 0xfb };
static const unsigned char ua9[] = {
  0x00, 0x0, 0x53, 0x5f, 0x0, 0x7c,
  0x80, 0x0, 0xcd, 0xcf, 0x0, 0xd9,
  0xde, 0xdf };
static const unsigned char uaa[] = {
  0x00, 0x0, 0x36, 0x40, 0x0, 0x4d,
  0x50, 0x0, 0x59, 0x5c, 0x0, 0x7b,
  0x80, 0x0, 0xc2, 0xdb, 0x0, 0xdf };
static const unsigned char uab[] = {
  0xc0, 0x0, 0xed, 0xf0, 0x0, 0xf9 };
/* uac to ud6 is all-print */
static const unsigned char ud7[] = {
  0x00, 0x0, 0xa3, 0xb0, 0x0, 0xc6,
  0xcb, 0x0, 0xfb };
/* ud8 to udf are UTF-16 surrogates, non-printable */
/* ue0 to uf9 is all-print */
static const unsigned char ufa[] = {
  0x00, 0x0, 0x2d, 0x30, 0x0, 0x6d,
  0x70, 0x0, 0xd9 };
static const unsigned char ufb[] = {
  0x00, 0x0, 0x06, 0x13, 0x0, 0x17,
  0x1d, 0x0, 0x36, 0x38, 0x0, 0x3c,
  0x3e, 0x40, 0x41, 0x43, 0x44, 
  0x46, 0x0, 0xb1, 0xd3, 0x0, 0xff };
/* ufc is all-print */
static const unsigned char ufd[] = {
  0x00, 0x0, 0x3f, 0x50, 0x0, 0x8f,
  0x92, 0x0, 0xc7, 0xf0, 0x0, 0xfd };
static const unsigned char ufe[] = {
  0x00, 0x0, 0x19, 0x20, 0x0, 0x26,
  0x30, 0x0, 0x52, 0x54, 0x0, 0x66,
  0x68, 0x0, 0x6b, 0x70, 0x0, 0x74,
  0x76, 0x0, 0xfc, 0xff };
static const unsigned char uff[] = {
  0x01, 0x0, 0xbe, 0xc2, 0x0, 0xc7, 0xca, 0x0, 
  0xcf, 0xd2, 0x0, 0xd7, 0xda, 0x0, 0xdc, 0xe0, 
  0x0, 0xe6, 0xe8, 0x0, 0xee, 0xf9, 0x0, 0xfd }; 
static const unsigned char u100[] = {
  0x00, 0x0, 0x0b, 0x0d, 0x0, 0x26,
  0x28, 0x0, 0x3a, 0x3c, 0x3d, 0x3f, 0x0, 0x4d,
  0x50, 0x0, 0x5d, 0x80, 0x0, 0xfa };
static const unsigned char u101[] = {
  0x00, 0x0, 0x02, 0x07, 0x0, 0x33,
  0x37, 0x0, 0x8a, 0x90, 0x0, 0x9b,
  0xd0, 0x0, 0xfd };
static const unsigned char u102[] = {
  0x80, 0x0, 0x9c, 0xa0, 0x0, 0xd0 };
static const unsigned char u103[] = {
  0x00, 0x0, 0x1e, 0x20, 0x0, 0x23,
  0x30, 0x0, 0x4a, 0x80, 0x0, 0x9d,
  0x9f, 0x0, 0xc3, 0xc8, 0x0, 0xd5 };
static const unsigned char u104[] = {
  0x00, 0x0, 0x9d, 0xa0, 0x0, 0xa9 };
static const unsigned char u108[] = {
  0x00, 0x0, 0x05, 0x08, 0x0a, 0x0, 0x35,
  0x37, 0x38, 0x3c, 0x3f, 0x0, 0x55,
  0x57, 0x0, 0x5f };
static const unsigned char u109[] = {
  0x00, 0x0, 0x1b, 0x1f, 0x0, 0x39, 0x3f };
static const unsigned char u10a[] = {
  0x00, 0x0, 0x03, 0x05, 0x06, 0x0c, 0x0, 0x13,
  0x15, 0x0, 0x17, 0x19, 0x0, 0x33,
  0x38, 0x0, 0x3a, 0x3f, 0x0, 0x47,
  0x50, 0x0, 0x58, 0x60, 0x0, 0x7f };
static const unsigned char u10b[] = {
  0x00, 0x0, 0x35, 0x39, 0x0, 0x55,
  0x58, 0x0, 0x72, 0x78, 0x0, 0x7f };
static const unsigned char u10c[] = {
  0x00, 0x0, 0x48 };
static const unsigned char u10e[] = {
  0x60, 0x0, 0x7e };
static const unsigned char u110[] = {
  0x80, 0x0, 0xc1 };
/* u120 to u122 is all-print */
static const unsigned char u123[] = {
  0x00, 0x0, 0x6e };
static const unsigned char u124[] = {
  0x00, 0x0, 0x62, 0x70, 0x0, 0x73 };
/* u130 to u133 is all-print */
static const unsigned char u134[] = {
  0x00, 0x0, 0x2e };
static const unsigned char u1d0[] = {
  0x00, 0x0, 0xf5 };
static const unsigned char u1d1[] = {
  0x00, 0x0, 0x26, 0x29, 0x0, 0xdd };
static const unsigned char u1d2[] = {
  0x00, 0x0, 0x45 };
static const unsigned char u1d3[] = {
  0x00, 0x0, 0x56, 0x60, 0x0, 0x71 };
static const unsigned char u1d4[] = { 
  0x00, 0x0, 0x54, 0x56, 0x0, 0x9c, 0x9e, 0x0, 
  0x9f, 0xa2, 0xa5, 0x0, 0xa6, 0xa9, 0x0, 0xac, 
  0xae, 0x0, 0xb9, 0xbb, 0xbd, 0x0, 0xc3,
  0xc5, 0x0, 0xff };
static const unsigned char u1d5[] = {
  0x00, 0x0, 0x05, 0x07, 0x0, 0x0a, 
  0x0d, 0x0, 0x14, 0x16, 0x0, 0x1c, 0x1e, 0x0, 
  0x39, 0x3b, 0x0, 0x3e, 0x40, 0x0, 0x44, 0x46, 
  0x4a, 0x0, 0x50, 0x52, 0x0, 0xff };
static const unsigned char u1d6[] = {
  0x00, 0x0, 0xa5, 0xa8, 0x0, 0xff };
static const unsigned char u1d7[] = {
  0x00, 0x0, 0xcb, 0xce, 0x0, 0xff };
static const unsigned char u1f0[] = {
  0x00, 0x0, 0x2b, 0x30, 0x0, 0x93 };
static const unsigned char u1f1[] = {
  0x00, 0x0, 0x0a, 0x10, 0x0, 0x2e,
  0x31, 0x3d, 0x3f, 0x42, 0x46, 0x4a, 0x0, 0x4e,
  0x57, 0x5f, 0x79, 0x7b, 0x7c, 0x7f, 0x8a, 0x0,
  0x8c, 0x8d, 0x90 };
static const unsigned char u1f2[] = {
  0x00, 0x10, 0x0, 0x31, 0x40, 0x0, 0x48 };
/* u200 to u2a5 is all-print */
static const unsigned char u2a6[] = {
  0x00, 0x0, 0xd6 };
/* u2a7 to u2b6 is all-print */
static const unsigned char u2b7[] = {
  0x00, 0x0, 0x34 };
/* u2f8 to u2f9 is all-print */
static const unsigned char u2fa[] = {
  0x00, 
  0x0, 0x1d };
static const unsigned char ue00[] = {
  0x01, 0x20, 0x0, 0x7f };
static const unsigned char ue01[] = {
  0x00, 0x0, 0xef };
/* uf00 to uffe is all-print */
static const unsigned char ufff[] = {
  0x00, 0x0, 0xfd };
/* u1000 to u10fe is all-print */
static const unsigned char u10ff[] = {
  0x00, 0x0, 0xfd };
