/*
 * cluster_info.h - An array in cluster descriptor describing the whole mesh
 * 
 * Authors  Nicolas Phan    (2018)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <cluster_info.h>

int cluster_info_is_active( uint16_t cluster_info )
{
    return (cluster_info & CINFO_ACTIVE);
}

/*
int cluster_info_cluster_ok( uint16_t cluster_info )
{
    if ((cluster_info & CINFO_ACTIVE) &&  // If the cluster is not empty
        (cluster_info & CINFO_RAM_OK) &&  // and its RAM is working
        (cluster_info & CINFO_XCU_OK) &&  // and its XCU is working
        (cluster_info & CINFO_CORES_MASK) ) // and at least one core works
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

int cluster_info_core_ok( uint16_t cluster_info, int n)
{
    if ( n < 0 || n >= NB_TOTAL_PROCS )
    {
        return -1;
    }
    return (cluster_info & (1 << n));
}
*/
