/*
 * shared_dirent.h - Shared structure used by the opendir() / readdir() / closedir() syscalls.
 *
 * Author  Alain Greiner (2016,2017,2018)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SHARED_DIRENT_H_
#define _SHARED_DIRENT_H_

/*******************************************************************************************
 * These two structure defines the informations returned to user by the opendir()
 * function, used by the readdir() function, and released by the closedir() function.
 * - "DIR" describes the complete directory.
 * - "dirent" describes one directory entry.
 ******************************************************************************************/

#define DIRENT_NAME_MAX_LENGTH  56
#define DIRENT_MAX_NUMBER       63

struct dirent
{
    unsigned int   inum;                                /*! inode identifier              */
    unsigned int   type;                                /*! inode type                    */
    char           name[DIRENT_NAME_MAX_LENGTH];        /*! directory entry name          */
};

typedef struct user_directory
{
    struct dirent   entry[DIRENT_MAX_NUMBER];
    unsigned int    current;
}
DIR;

#endif
