/**********************************************************************************************
 * This is the linker script for the ALMOS-MK boot-loader used for the TSAR architecture.
 * It describes the memory layout for the 'boot.elf' binary file.
 *********************************************************************************************/

/* define the boot code base address */

boot_code_base = 0x900000;

/* Set the entry point of the boot-loader (e_entry field in the "boot.elf" file header) */ 

ENTRY(boot_entry)

/* Describe how to group the sections */

SECTIONS
{
    . = boot_code_base;
    .text :
    {
        *(.text)
        *(.rodata*)
    }
    . = ALIGN(0x1000);
    .data :
    {
        *(.data*)
    }
    .bss :
    {
        *(.bss)
    }
}
