/*
 * shared_stat.h - Shared structure used by the stat() syscall.
 *
 * Author  Alain Greiner (2016,2017,2018)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SHARED_STAT_H_
#define _SHARED_STAT_H_

/******************************************************************************************
 * This structure define the informations associated to a file descriptor,
 * returned to user space by the stat() syscall.
 *****************************************************************************************/

typedef struct stat 
{
	unsigned int    dev;        /*! ID of device containing file                             */
	unsigned int    inum;       /*! inode number                                             */
	unsigned int    mode;       /*! protection                                               */
	unsigned int    nlink;      /*! number of hard links                                     */
	unsigned int    uid;        /*! user ID of owner                                         */
	unsigned int    gid;        /*! group ID of owner                                        */
	unsigned int    rdev;       /*! device ID (if special file)                              */
	unsigned int    size;       /*! total size, in bytes                                     */
	unsigned int    blksize;    /*! blocksize for file system I/O                            */
	unsigned int    blocks;     /*! number of 512B blocks allocated                          */
}
stat_t;

#endif /* _STAT_H_ */
