/****************************************************************************
* Definition of the base address for all virtual segments
*****************************************************************************/

seg_code_base      = 0x400000;

/***************************************************************************
* Grouping sections into segments for code and data
***************************************************************************/

SECTIONS
{
    . = seg_code_base;
    seg_code : 
    {
        *(.text)
        *(.text.*)
    }

    . = ALIGN(0x1000);

    seg_data : 
    {
        *(.ctors)
        *(.rodata)
        *(.rodata.*)
        *(.data)
        *(.lit8)
        *(.lit4)
        *(.sdata)
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
    }
}

