/*
 * shared_almos.h - Shared mnemonics used by the almos-mkh specific syscalls.
 *
 * Author  Alain Greiner (2016,2017,2018)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SHARED_ALMOS_H_
#define _SHARED_ALMOS_H_

/******************************************************************************************* 
 * This enum defines the operation mnemonics for the utls() syscall (Thread Local Storage).
 ******************************************************************************************/

typedef enum
{
    UTLS_SET       = 1,
    UTLS_GET       = 2,
    UTLS_GET_ERRNO = 3,
}
utls_operation_t;

/******************************************************************************************* 
 * This enum defines the type of structure for the display() syscall.
 ******************************************************************************************/

typedef enum
{
    DISPLAY_STRING            = 0,
    DISPLAY_VMM               = 1,
    DISPLAY_SCHED             = 2,
    DISPLAY_CLUSTER_PROCESSES = 3,
    DISPLAY_VFS               = 4,
    DISPLAY_CHDEV             = 5,
    DISPLAY_TXT_PROCESSES     = 6,
    DISPLAY_DQDT              = 7,
    DISPLAY_BUSYLOCKS         = 8,
    DISPLAY_MAPPER            = 9,
    DISPLAY_BARRIER           = 10,
    DISPLAY_FAT               = 11,
}
display_type_t;

/******************************************************************************************* 
 * This structure defines the - user accessible - information stored in a thread.
 ******************************************************************************************/

typedef struct thread_info_s
{
	unsigned long      false_pgfault_nr;     /*! number of local page fault               */
    unsigned long      false_pgfault_cost;   /*! cumulated cost                           */
    unsigned long      false_pgfault_max;    /*! max cost of a local page fault           */

	unsigned long      local_pgfault_nr;     /*! number of local page fault               */
    unsigned long      local_pgfault_cost;   /*! cumulated cost                           */
    unsigned long      local_pgfault_max;    /*! max cost of a false page fault           */

	unsigned long      global_pgfault_nr;    /*! number of global page fault              */
    unsigned long      global_pgfault_cost;  /*! cumulated cost                           */
    unsigned long      global_pgfault_max;   /*! max cost of a global page fault          */

	unsigned long long last_cycle;           /*! last cycle counter value (date)          */
	unsigned long long usr_cycles;           /*! user execution duration (cycles)         */
	unsigned long long sys_cycles;           /*! system execution duration (cycles)       */
}
thread_info_t;

#endif /* _SHARED_ALMOS_H_ */

