/*
 * shared_framebuffer.h - Shared mnemonics used by the frame buffer related syscalls.
 *
 * Author  Alain Greiner (2016,2017,2018,2019)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SHARED_FRAMEBUFFER_H_
#define _SHARED_FRAMEBUFFER_H_

/******************************************************************************************* 
 * This enum defines the operation mnemonics for frame buffer access.
 ******************************************************************************************/

typedef enum
{
    FBF_GET_CONFIG = 0,      
    FBF_READ       = 1,
    FBF_WRITE      = 2,
}
fbf_operation_type_t;

#endif  // _SHARED_FRAMEBUFFER_H_
