/*
 * soclib_fbf.h - soclib frame-buffer driver definition (used in TSAR_IOB architecture).
 *
 * Author Alain greiner (2016,2017,2018,2019)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SOCLIB_FBF_H_
#define _SOCLIB_FBF_H_

#include <chdev.h>
#include <hal_kernel_types.h>

/****************************************************************************************
 * This driver supports the vci_fbf_tsar component.
 *
 * This hardware component supports both a frame buffer, and a set of addressable
 * configuration status registers.
 ***************************************************************************************/

/****************************************************************************************
 *                    SOCLIB_FBF registers offsets
 * The three addressables registers are on top  of the 4 Mbytes allocated
 * to the frame buffer itself.
 ***************************************************************************************/

enum SoclibFrameBufferRegisters
{
    FBF_WIDTH_REG        = 0x100000,
    FBF_HEIGHT_REG       = 0x100001,
    FBF_SUBSAMPLING_REG  = 0x100002,
};

/****************************************************************************************
 * This function access the SOCLIB_FBF hardware registers, to get the frame buffer
 * size and type, and update the FBF device extension.
 ****************************************************************************************
 * @ chdev     : pointer on the FBF chdev descriptor.
 ***************************************************************************************/
void soclib_fbf_init( chdev_t * chdev );

/****************************************************************************************
 * This function implements the FBF_READ and FBF_WRITE commands registered in the client 
 * thread descriptor identified by the <thread_xp> argument.
 * It is called directly by the client thread.
 * **************************************************************************************
 * @ thread_xp : extended pointer on client thread descriptor.
 ***************************************************************************************/
extern void soclib_fbf_cmd( xptr_t thread_xp );

#endif
