/***************************************************************************************
 * This is the linker script for the ALMOS-MKH kernel code on the TSAR architecture.
 * It describes the memory layout for the "kernel.elf" binary file, containing the two 
 * loadable segments, that MUST be identity mapped for the TSAR architecture. 
 * 
 * WARNING : the seg_kcode_base defined below must be coherent
 * with the values defined in the boot_config.h file used by the TSAR bootloader. 
 **************************************************************************************/

/* Define the kernel code base addresses */

seg_kcode_base  = 0x00004000;

/* Define the e_entry field in the "kernel.elf" file header) */

ENTRY(kernel_init)

/* Describe how to group the sections */

SECTIONS
{
	. = seg_kcode_base;
	seg_kcode :
	{
		*(.kentry)
		*(.switch)
		*(.text)
		*(.rodata*)
	}

	. = ALIGN(0x1000);

	seg_kdata :
	{
		*(.kinfo)
		*(.kidle)
		*(.kdata*)
        *(.scommon)
        *(.bss)
        *(.eh*)
		*(.data*)
	}
}
