/*******************************************************************
 * This is the linker script for the ALMOS-MKH boot-loader, 
 * to generate the 'boot.elf' file used for the TSAR architecture.
 *******************************************************************/

/* define the boot code base address */

boot_code_base = 0x200000;

/* Set the entry point of the boot-loader */
/* (e_entry field in the "boot.elf" file header) */ 

ENTRY(boot_entry)

/* Describe how to group the sections */

SECTIONS
{
    . = boot_code_base;
    .code :
    {
        *(.text)
        *(.rodata*)
    }
    . = ALIGN(0x1000);
    .data :
    {
        *(.data*)
        *(.bss)
        *(.scommon)
    }
}
