/**********************************************************************************************
 * This is the linker script for the ALMOS-MK kernel.
 * It describes the memory layout for the "kernel.elf" binary file.
 *********************************************************************************************/

/* define the kernel code base address */

kernel_base = 0x400000;

/* Set the entry point of the boot-loader (e_entry field in the "boot.elf" file header) */ 

ENTRY(kernel_init)

/* Describe how to group the sections */

SECTIONS
{
    . = kernel_base;
    .text :
    {
        *(.text)
        *(.rodata*)
    }
    . = ALIGN(0x1000);
    .data :
    {
        *(.data*)
    }
    .bss :
    {
        *(.bss)
    }
}
