/*
 * hal_arch.h - Generic Inter-Processor-Interrupt API definition.
 *
 * Authors   Alain Greiner  (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <soclib_xicu.h>
#include <hal_internal.h>

/*****************************************************************************************
 * This enum defines the various Inter Processor Interrupt types.
 ****************************************************************************************/

enum ipi_types
{
	TODO
};


/*****************************************************************************************
 ****************************************************************************************/
static void cpu_default_irq_handler(struct irq_action_s *action)
{
	x86_panic((char *)__func__);
}

error_t hal_arch_init(struct cpu_s *cpu)
{
	x86_panic((char *)__func__);
	return 0;
}

error_t arch_cpu_set_irq_entry(struct cpu_s *cpu, int irq_nr, struct irq_action_s *action)
{
	x86_panic((char *)__func__);
	return 0;
}

error_t arch_cpu_get_irq_entry(struct cpu_s *cpu, int irq_nr, struct irq_action_s **action)
{
	x86_panic((char *)__func__);
	return 0;
}
	
error_t arch_set_power_state(struct cpu_s *cpu, arch_power_state_t state)
{
	x86_panic((char *)__func__);
	return 0;
}

sint_t arch_barrier_init(struct cluster_s *cluster, struct event_s *event, uint_t count)
{
	x86_panic((char *)__func__);
	return 0;
}

sint_t arch_barrier_wait(struct cluster_s *cluster, uint_t barrier_id)
{
	x86_panic((char *)__func__);
	return 0;
}

error_t arch_barrier_destroy(struct cluster_s *cluster, uint_t barrier_id)
{
	x86_panic((char *)__func__);
	return 0;
}

/*****************************************************************************************
 * This function send an IPI (Inter Processor Interrupt) to a core identified by
 * its cluster identifier and local index. A 32 bits value defining the IPI type
 * is transmited with the IPI and can be analysed by the associated ISR.
 *****************************************************************************************
 * @ cxy      : destination cluster identifier.
 * @ lid      : destination core local index.
 * @ type     : to be transmitted in IPI.
 * @ return 0 if success (IPI registered) / returns EINVAL if illegal cxy or lid.
 ****************************************************************************************/
error_t hal_send_ipi( cxy_t    cxy,
                      lid_t    lid, 
                      uint32_t type );
