/*
 * hal_cpu.S - Miscellaneous CPU functions
 * 
 * Copyright (c) 2017 Maxime Villard
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#define x86_ASM
#include <hal_boot.h>

ASM_ENTRY(lgdt)
	lgdt	(%rdi)
	ret

ASM_ENTRY(lidt)
	lidt	(%rdi)
	ret

ASM_ENTRY(ltr)
	ltr	%di
	ret

ASM_ENTRY(invlpg)
	invlpg	(%rdi)
	ret

ASM_ENTRY(rdmsr)
	movq	%rdi,%rcx
	xorq	%rax,%rax
	rdmsr
	shlq	$32,%rdx
	orq	%rdx,%rax
	ret

ASM_ENTRY(wrmsr)
	movq	%rdi,%rcx
	movq	%rsi,%rax
	movq	%rsi,%rdx
	shrq	$32,%rdx
	wrmsr
	ret

