/*
 * sys_thread_wakeup.c - wakeup all indicated threads
 * 
 * Author    Alain Greiner (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <thread.h>
#include <printk.h>
#include <process.h>
#include <errno.h>

//////////////////////////////////////
int sys_thread_wakeup( trdid_t trdid )
{
	thread_t  * this    = CURRENT_THREAD;
    process_t * process = this->process;

    // get target thread ltid and cxy
    ltid_t   target_ltid = LTID_FROM_TRDID( trdid );
    cxy_t    target_cxy  = CXY_FROM_TRDID( trdid );

    // check trdid argument
	if( (target_ltid >= CONFIG_THREAD_MAX_PER_CLUSTER) || cluster_is_undefined( target_cxy ) )  
	{
        printk("\n[ERROR] in %s : illegal trdid argument\n", __FUNCTION__ );
		this->errno = EINVAL;
		return -1;
	}

    // get extended pointer on target thread
    xptr_t thread_xp = thread_get_xptr( process->pid , trdid );

    if( thread_xp == XPTR_NULL )
    {
        printk("\n[ERROR] in %s : cannot find thread %x in process %x/n",
               __FUNCTION__ , trdid , CURRENT_THREAD->process->pid );
        CURRENT_THREAD->errno = EINVAL;
        return -1;
    }

    // unblock target thread
    thread_unblock( thread_xp , THREAD_BLOCKED_GLOBAL );

    return 0;
}  // end sys_thread_wakeup()
