/*
 * hal_internal.h - x86-specific function definitions
 * 
 * Copyright (c) 2017 Maxime Villard
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#define offsetof(type, member) __builtin_offsetof(type, member)
#define roundup(x, y) ((((x)+((y)-1))/(y))*(y))
#define rounddown(x,y) (((x)/(y))*(y))

#define XASSERT(a)	\
	if (!(a)) { \
		x86_panic((char *)__func__); \
	}

/* hal_cpu.S */
void invlpg(vaddr_t va);
void sti();
void cli();
uint64_t rdmsr(uint32_t);
void wrmsr(uint32_t, uint64_t);

/* hal_gpt.c */
paddr_t hal_gpt_bootstrap_palloc(size_t npages);
vaddr_t hal_gpt_bootstrap_valloc(size_t npages);
void hal_gpt_bootstrap_reset();
void hal_gpt_enter(vaddr_t va, paddr_t pa);
void hal_gpt_enter_range(vaddr_t va, paddr_t pa, size_t n);
void hal_gpt_leave(vaddr_t va);
void hal_gpt_leave_range(vaddr_t va, size_t n);
void hal_gpt_init(paddr_t firstpa);

/* hal_special.c */
void hal_tls_init_cpu0();

/* x86_printf.c */
void x86_panic(char *msg);
void x86_printf(char *s, ...);

