/*
 * fatfs.c - FATFS file system API implementation.
 *
 * Author    Mohamed Lamine Karaoui (2015)
 *           Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */


#include <hal_types.h>
#include <hal_special.h>
#include <printk.h>
#include <kmem.h>
#include <vfs.h>
#include <fatfs.h>


///////////////////////////////////////////////////////////////////////////////////////
// FATFS specific functions : these static functions cannot be directly
//                            called by the VFS 
///////////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////////
// Generic API : the following functions are called by the VFS, 
//               and must be defined by all supported file systems.
///////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
error_t fatfs_inode_create( struct vfs_inode_s * vfs_inode )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();

    kmem_req_t      req;
    error_t         error;
    fatfs_inode_t * fatfs_inode;
    uint32_t        cluster;        // allocated cluster index

    // allocate memory for fatfs inode
	req.type    = KMEM_FATFS_INODE;
	req.size    = sizeof(fatfs_inode_t);
    req.flags   = AF_KERNEL | AF_ZERO;
	fatfs_inode = (fatfs_inode_t *)kmem_alloc( &req );

    if( fatfs_inode == NULL ) return ENOMEM;

    // initialise ramfs_inode 
    fatfs_inode->first_cluster = 0;   // TODO ???
    fatfs_inode->ctx           = (fatfs_ctx_t *)vfs_inode->ctx->extend;
 
    // link vfs_inode to ramfs_inode
    inode->extend    = ramfs_inode;
    ramfs->vfs_inode = vfs_inode;

    return 0;

}

//////////////////////////////////////////////////////
void fatfs_inode_destroy( struct vfs_inode_s * inode )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();
}

////////////////////////////////////////////////
error_t fatfs_write_page( struct page_s * page )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();

    // get pointer on mapper and page index from page descriptor
    mapper_t * mapper = page->mapper;
    uint32_t   index  = page->index;

    if( mapper == NULL)
    {
        printk("\n[PANIC] in %s : no mapper for this page\n", __FUNCTION__ );
        hal_core_sleep();
    }

    // get VFS inode pointer from mapper
    vfs_inode_t * vfs_inode = mapper->inode;

    // get FATFS inode pointer for VFS inode
    fatfs_inode_t * fatfs_inode = (fatfs_inode_t)vfs_inode->extend;

    // get FATFS context and first cluster from FATFS inode
    fatfs_ctx_t * fatfs_ctx     = fatfs_inode->ctx;
    uint32_t      first_cluster = fatfs_inode->first_cluster;


}

///////////////////////////////////////////////
error_t fatfs_read_page( struct page_s * page )
{
    printk("\n[PANIC] %s not fully implemented yet\n", __FUNCTION__ );
    hal_core_sleep();

    // get pointer on mapper and page index from page descriptor
    mapper_t * mapper = page->mapper;
    uint32_t   index  = page->index;

    if( mapper == NULL)
    {
        printk("\n[PANIC] in %s : no mapper for this page\n", __FUNCTION__ );
        hal_core_sleep();
    }

    // get VFS inode pointer from mapper
    vfs_inode_t * vfs_inode = mapper->inode;

    // get FATFS inode pointer for VFS inode
    fatfs_inode_t * fatfs_inode = (fatfs_inode_t)vfs_inode->extend;

    // get FATFS context and first cluster from FATFS inode
    fatfs_ctx_t * fatfs_ctx     = fatfs_inode->ctx;
    uint32_t      first_cluster = fatfs_inode->first_cluster;


}

