/*
 * printk.h - Kernel Log & debug messages API definition.
 * 
 * authors  Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

///////////////////////////////////////////////////////////////////////////////////
// The printk.c and printk.h files define the functions used by the kernel
// to display messages on the kernel text terminal, using a busy waiting
// policy if required : these functions does not use the TXT kernel thread,
// and does not deschedule if TXT peripheral is not available.
// These functions use the generic TXT device to call the proper implementation
// dependant TXT driver.
///////////////////////////////////////////////////////////////////////////////////

#ifndef _PRINTK_H
#define _PRINTK_H

///////////////////////////////////////////////////////////////////////////////////
//       Access functions to kernel terminal TTY0 
///////////////////////////////////////////////////////////////////////////////////

extern void         printk( char* format, ... );

extern void         nolock_printk( char* format, ... );

extern void         user_printk( char* format, ... );

///////////////////////////////////////////////////////////////////////////////////
//       Conditionnal debug macros
///////////////////////////////////////////////////////////////////////////////////

#if CONFIG_CORE_DEBUG
#define core_dmsg(...)   printk(__VA__ARGS__)
#else
#define core_dmsg(...)
#endif

#if CONFIG_DQDT_DEBUG
#define dqdt_dmsg(...)   printk(__VA__ARGS__)
#else
#define dqdt_dmsg(...)
#endif

#if CONFIG_ELF_DEBUG
#define elf_dmsg(...)   printk(__VA__ARGS__)
#else
#define elf_dmsg(...)
#endif

#if CONFIG_FORK_DEBUG
#define fork_dmsg(...)   printk(__VA__ARGS__)
#else
#define fork_dmsg(...)
#endif

#if CONFIG_EXEC_DEBUG
#define exec_dmsg(...)   printk(__VA__ARGS__)
#else
#define exec_dmsg(...)
#endif

#if CONFIG_ICU_DEBUG
#define icu_dmsg(...)   printk(__VA__ARGS__)
#else
#define icu_dmsg(...)
#endif

#if CONFIG_IOC_DEBUG
#define ioc_dmsg(...)   printk(__VA__ARGS__)
#else
#define ioc_dmsg(...)
#endif

#if CONFIG_KINIT_DEBUG
#define kinit_dmsg(...) printk(__VA_ARGS__)
#else
#define kinit_dmsg(...)
#endif

#if CONFIG_KMEM_DEBUG
#define kmem_dmsg(...) printk(__VA_ARGS__)
#else
#define kmem_dmsg(...)
#endif

#if CONFIG_MMC_DEBUG
#define mmc_dmsg(...)   printk(__VA__ARGS__)
#else
#define mmc_dmsg(...)
#endif

#if CONFIG_NIC_DEBUG
#define nic_dmsg(...)   printk(__VA__ARGS__)
#else
#define nic_dmsg(...)
#endif

#if CONFIG_PIC_DEBUG
#define pic_dmsg(...)   printk(__VA__ARGS__)
#else
#define pic_dmsg(...)
#endif

#if CONFIG_PROCESS_DEBUG
#define process_dmsg(...)   printk(__VA__ARGS__)
#else
#define process_dmsg(...)
#endif

#if CONFIG_RPC_DEBUG
#define rpc_dmsg(...)   printk(__VA__ARGS__)
#else
#define rpc_dmsg(...)
#endif

#if CONFIG_SCHED_DEBUG
#define sched_dmsg(...)   printk(__VA__ARGS__)
#else
#define sched_dmsg(...)
#endif

#if CONFIG_THREAD_DEBUG
#define thread_dmsg(...)   printk(__VA__ARGS__)
#else
#define thread_dmsg(...)
#endif

#if CONFIG_TXT_DEBUG
#define txt_dmsg(...)   printk(__VA__ARGS__)
#else
#define txt_dmsg(...)
#endif

#if CONFIG_VFS_DEBUG
#define vfs_dmsg(...)   printk(__VA__ARGS__)
#else
#define vfs_dmsg(...)
#endif

#if CONFIG_VMM_DEBUG
#define vmm_dmsg(...)   printk(__VA__ARGS__)
#else
#define vmm_dmsg(...)
#endif


#endif  // _PRINTK_H

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

