/*
 * memcpy.c - architecture independent memory copy functions
 *
 * Author ALain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>

/////////////////////////////////
void * memcpy( void       * dst,
               const void * src,
               uint32_t     size) 
{
    uint32_t       * wdst = dst;
    const uint32_t * wsrc = src;

    if (!((uint32_t) wdst & 3) && !((uint32_t) wsrc & 3) )
    {
        while (size > 3) 
        {
            *wdst++ = *wsrc++;
            size -= 4;
        }
    }

    unsigned char *cdst = (unsigned char*)wdst;
    unsigned char *csrc = (unsigned char*)wsrc;

    while (size--) 
    {
        *cdst++ = *csrc++;
    }
    return dst;
}

///////////////////////////
void * memset( void   * dst, 
               int      s,
               uint32_t size) 
{
    char * a = (char *) dst;
    while (size--)
    {
        *a++ = (char)s;
    }
    return dst;
}

