/*
 * remote_barrier.c - distributed kernel barrier implementaion 
 * 
 * Author   Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_remote.h>
#include <remote_barrier.h>

/////////////////////////////////////////
inline void remote_barrier( xptr_t    xp,
                            uint32_t  count ) 
{
    uint32_t  expected;

    remote_barrier_t * ptr = (remote_barrier_t *)GET_PTR( xp );
    cxy_t              cxy = GET_CXY( xp );

    // get barrier sense value
    uint32_t sense = hal_remote_lw( XPTR( cxy , &ptr->sense ) );

	// compute expected value
    if ( sense == 0 ) expected = 1;
    else              expected = 0;

    // increment count
    uint32_t current = hal_remote_atomic_add( XPTR( cxy , &ptr->current ) , 1 );

    // last task reset current and toggle sense
    if( current == (count-1) ) 
    {
        hal_remote_sw( XPTR( cxy , &ptr->current) , 0 );  
        hal_remote_sw( XPTR( cxy , &ptr->sense  ) , expected );  
    }
    else   // other tasks poll the sense 
    {
        while( hal_remote_lw( XPTR( cxy , &ptr->sense ) ) != expected ) asm volatile ("nop");
    }
}


