/****************************************************************************
 * This file defines various hardware and configuration parameters for the  *
 * ALMOS-MKH boot-loader.                                                    *
 ****************************************************************************/

#ifndef _BOOT_CONFIG_H
#define _BOOT_CONFIG_H

// Debug options
#define DEBUG_BOOT_INFO     1
#define DEBUG_BOOT_ELF      1
#define DEBUG_BOOT_IOC      0
#define DEBUG_BOOT_FAT32    1
#define USE_FIXED_FORMAT    0

// io_cluster identifier
#define IO_CXY              0

// Peripheral base addresses (in io_cluster)
#define SEG_IOC_BASE        0xb3000000
#define SEG_TTY_BASE        0xb4000000
#define SEG_MMC_BASE        0xb2000000

// boot code temporary segment
#define BOOT_BASE           0x100000        /* 'boot.elf' base address.     */
#define BOOT_MAX_SIZE       0x100000        /* 'boot.elf' max size.         */

// arch_info temporary segment
#define ARCHINFO_BASE       0x200000        /* 'arch_info.bin' base address */
#define ARCHINFO_MAX_SIZE   0x200000        /* 'arch_info.bin' max size.    */

// kernel code temporary segment
#define KERN_BASE           0x400000        /* 'kernel.elf' base address    */
#define KERN_MAX_SIZE       0x100000        /* 'kernel.elf' max size.       */

// Preloader temporary segment
#define PRELOADER_BASE      0x0             /* Preloader base address.      */
#define PRELOADER_MAX_SIZE  0x100000        /* Preloader max size.          */

// Temporary stacks segments
#define BOOT_STACK_BASE     0x504000        /* Boot stack base address.     */
#define BOOT_STACK_SIZE     0x1000          /* Boot stack size (4Kb)        */

// Pas clair du tout TODO   [AG]
#define KERN_IMG_TMP_BASE   0X600000

#endif  // _BOOT_CONFIG_H
