/*
 * sys_close.c  close a process open file
 * 
 * Copyright (c) 2008,2009,2010,2011,2012 Ghassan Almaless
 * Copyright (c) 2011,2012 UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-kernel.
 *
 * ALMOS-kernel is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-kernel is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-kernel; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <cpu.h>
#include <chdev.h>
#include <driver.h>
#include <vfs.h>
#include <sys-vfs.h>
#include <process.h>
#include <thread.h>
#include <config.h>

/////////////////////////////
int sys_close ( uint32_t fd )
{
	register process_t * process = current_process;
	register thread_t  * this    = current_thread;
	struct vfs_file_s  * file    = NULL;
	error_t              err;
  
	if(( fd >= CONFIG_TASK_FILE_MAX_NR ) || (process_fd_lookup( process , fd , &file )))
	{
		this->info.errno = EBADFD;
		return -1;
	}

	err = vfs_close( file , NULL );
	if( err )
	{
		this->info.errno = err;
		return -1;
	}

	process_fd_release( process , fd );
	cpu_wbflush();
	return 0;
}
