/*
 * syscalls.h - kernel services definition
 * 
 * Author  Ghassan Almaless (2007,2008,2009,2010,2011,2012)
 *         Alain Greiner    (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SYSCALLS_H_
#define _SYSCALLS_H_

/******************************************************************************************
 * This enum defines the mnemonics for the syscall indexes.
 * It must be kept consistent with the array defined in do_syscalls.c
 *****************************************************************************************/
enum
{
	SYS_EXIT,          /* 0  */
	SYS_MMAP,          /* 1  */
	SYS_CREATE,        /* 2  */
	SYS_JOIN,          /* 3  */
	SYS_DETACH,        /* 4  */
	SYS_YIELD,         /* 5  */
	SYS_SEMAPHORE,     /* 6  */
	SYS_COND_VAR,      /* 7  */
	SYS_BARRIER,       /* 8  */
	SYS_RWLOCK,        /* 9  */
	SYS_SLEEP,         /* 10 */
	SYS_WAKEUP,        /* 11 */
	SYS_OPEN,          /* 12 */
	SYS_CREAT,         /* 13 */
	SYS_READ,          /* 14 */
	SYS_WRITE,         /* 15 */
	SYS_LSEEK,         /* 16 */
	SYS_CLOSE,         /* 17 */
	SYS_UNLINK,        /* 18 */   
	SYS_PIPE,          /* 19 */
	SYS_CHDIR,         /* 20 */
	SYS_MKDIR,         /* 21 */
	SYS_MKFIFO,        /* 22 */    
	SYS_OPENDIR,       /* 23 */
	SYS_READDIR,       /* 24 */
	SYS_CLOSEDIR,      /* 25 */
	SYS_GETCWD,        /* 26 */
	SYS_CLOCK,         /* 27 */
	SYS_ALARM,         /* 28 */   
	SYS_DMA_MEMCPY,    /* 29 */
	SYS_UTLS,          /* 30 */  
	SYS_SIGRETURN,     /* 31 */
	SYS_SIGNAL,        /* 32 */
	SYS_SET_SIGRETURN, /* 33 */
	SYS_KILL,          /* 34 */
	SYS_GETPID,        /* 35 */
	SYS_FORK,          /* 36 */
	SYS_EXEC,          /* 37 */
	SYS_GETATTR,       /* 38 */     
	SYS_PS,            /* 39 */
	SYS_MADVISE,       /* 40 */   
	SYS_PAGEINFO,      /* 41 */
	SYS_STAT,          /* 42 */
	SYS_MIGRATE,       /* 43 */
	SYS_SBRK,          /* 44 */
	SYS_RMDIR,         /* 45 */
	SYS_FTIME,         /* 46 */
	SYS_CHMOD,         /* 47 */
	SYS_FSYNC,         /* 48 */
	SYS_GET_TOD,       /* 49 */
	SYS_TIMES,         /* 50 */
	SYSCALLS_NR,
};

/********************************************************************************************/
/********************   Process related system calls  ***************************************/ 
/********************************************************************************************/


/********************************************************************************************* 
 * [0] This function TODO
 ********************************************************************************************/
int sys_thread_exit( void * );

/********************************************************************************************* 
 * [1] This function TODO
 ********************************************************************************************/
int sys_mmap();

/********************************************************************************************* 
 * [2] This function TODO
 ********************************************************************************************/
int sys_thread_create();

/********************************************************************************************* 
 * [3] This function TODO
 ********************************************************************************************/
int sys_thread_join();

/********************************************************************************************* 
 * [4] This function TODO
 ********************************************************************************************/
int sys_thread_detach();

/********************************************************************************************* 
 * [5] This function TODO
 ********************************************************************************************/
int sys_thread_yield();

/********************************************************************************************* 
 * [6] This function TODO
 ********************************************************************************************/
int sys_sem();

/********************************************************************************************* 
 * [7] This function TODO
 ********************************************************************************************/
int sys_cond_var();

/********************************************************************************************* 
 * [8] This function TODO
 ********************************************************************************************/
int sys_barrier();

/********************************************************************************************* 
 * [9] This function TODO
 ********************************************************************************************/
int sys_rwlock();

/********************************************************************************************* 
 * [10] This function TODO
 ********************************************************************************************/
int sys_thread_sleep();

/********************************************************************************************* 
 * [11] This function TODO
 ********************************************************************************************/
int sys_thread_wakeup();

/********************************************************************************************* 
 * [12] This function TODO
 ********************************************************************************************/
int sys_open();

/********************************************************************************************* 
 * [13] This function TODO
 ********************************************************************************************/
int sys_creat();

/********************************************************************************************* 
 * [14] This function TODO
 ********************************************************************************************/
int sys_read();

/********************************************************************************************* 
 * [15] This function TODO
 ********************************************************************************************/
int sys_write();

/********************************************************************************************* 
 * [16] This function TODO
 ********************************************************************************************/
int sys_lseek();

/********************************************************************************************* 
 * [17] This function TODO
 ********************************************************************************************/
int sys_close();

/********************************************************************************************* 
 * [18] This function TODO
 ********************************************************************************************/
int sys_unlink();

/********************************************************************************************* 
 * [19] This function TODO
 ********************************************************************************************/
int sys_pipe();

/********************************************************************************************* 
 * [20] This function TODO
 ********************************************************************************************/
int sys_chdir();

/********************************************************************************************* 
 * [21] This function TODO
 ********************************************************************************************/
int sys_mkdir();

/********************************************************************************************* 
 * [22] This function TODO
 ********************************************************************************************/
int sys_mkfifo();

/********************************************************************************************* 
 * [23] This function TODO
 ********************************************************************************************/
int sys_opendir();

/********************************************************************************************* 
 * [24] This function TODO
 ********************************************************************************************/
int sys_readdir();

/********************************************************************************************* 
 * [25] This function TODO
 ********************************************************************************************/
int sys_closedir();

/********************************************************************************************* 
 * [26] This function TODO
 ********************************************************************************************/
int sys_getcwd();

/********************************************************************************************* 
 * [27] This function TODO
 ********************************************************************************************/
int sys_clock();

/********************************************************************************************* 
 * [28] This function TODO
 ********************************************************************************************/
int sys_alarm();

/********************************************************************************************* 
 * [29] This function TODO
 ********************************************************************************************/
int sys_dma_memcpy();

/********************************************************************************************* 
 * [30] This function TODO
 ********************************************************************************************/
int sys_utls();

/********************************************************************************************* 
 * [31] This function TODO
 ********************************************************************************************/
int sys_notAvailable();

/********************************************************************************************* 
 * [32] This function TODO
 ********************************************************************************************/
int sys_signal();

/********************************************************************************************* 
 * [33] This function TODO
 ********************************************************************************************/
int sys_sigreturn_setup();

/********************************************************************************************* 
 * [34] This function implements the "kill" system call.
 * It register the signal identified by the <sig> argument in all thread descriptors 
 * of process identified by the <pid> argument.
 ********************************************************************************************* 
 * @ pid      : target process identifier.
 * @ sig      : signal index. 
 ********************************************************************************************/
int sys_kill( pid_t    pid,
              uint32_t sig );

/********************************************************************************************* 
 * [35] This function TODO
 ********************************************************************************************/
int sys_getpid();

/********************************************************************************************* 
 * [36] This function implement the "fork" system call.
 * The calling process descriptor (parent process), and the associated thread descriptor are
 * replicated in the same cluster as the calling thread, but the new process (child process)
 * is registered in another target cluster, that will become the process owner. 
 * The child process and the associated main thread will be migrated to the target cluster
 * later, when the child process makes an "exec" or any other system call. 
 * The target cluster depends on the "fork_user" flag and "fork_cxy" variable that can be
 * stored in the calling thread descriptor by the specific fork_place() system call.
 * If not, the sys_fork() function makes a query to the DQDT to select the target cluster. 
 ********************************************************************************************* 
 * @ returns child process PID if success / returns -1 if failure
 ********************************************************************************************/
int sys_fork();

/********************************************************************************************* 
 * [37] This function implement the "exec" system call.
 * It is executed in the client cluster, but the new process descriptor and main thread
 * must be created in a server cluster, that is generally another cluster, using a RPC.
 * - If the server_cluster is the client cluster, call directly make_exec() in local
 *   mode, to change the process image and launch a new thread in local cluster.
 *   finally, the old thread is deleted.
 * - If the target_cluster is remote, call rpc_process_exec_client() to execute the
 *   make_exec() in remote mode on the remote cluster, to create a new process
 *   descriptor and a new thread on remote cluster. Finally, both the local
 *   process descriptor and the local thread descriptor are deleted.
 * In both case this function build an exec_info_t structure containing all informations
 * required to build the new process descriptor and the associated thread, including
 * the mode (local/remote).
 ********************************************************************************************* 
 * @ filename : string pointer on .elf filename (virtual pointer in user space)
 * @ argv     : array of strings on process arguments (virtual pointers in user space)
 * @ envp     : array of strings on Renvironment variables (virtual pointers in user space)
 * @ returns O if success / returns non-zero if error.
 ********************************************************************************************/
int sys_exec( char  * filename,
              char ** argv,
              char ** envp );

/********************************************************************************************* 
 * [38] This function TODO
 ********************************************************************************************/
int sys_thread_getattr();

/********************************************************************************************* 
 * [39] This function implements the ps system call.
 ********************************************************************************************/
int sys_ps( uint32_t cmd, 
            pid_t    pid, 
            uint32_t tid );

/********************************************************************************************* 
 * [40] This function TODO
 ********************************************************************************************/
int sys_madvise();

/********************************************************************************************* 
 * [41] This function TODO
 ********************************************************************************************/
int sys_mcntl();

/********************************************************************************************* 
 * [42] This function TODO
 ********************************************************************************************/
int sys_stat();

/********************************************************************************************* 
 * [43] This function TODO
 ********************************************************************************************/
int sys_thread_migrate();

/********************************************************************************************* 
 * [44] This function TODO
 ********************************************************************************************/
int sys_sbrk();

/********************************************************************************************* 
 * [45] This function TODO
 ********************************************************************************************/
int sys_rmdir();

/********************************************************************************************* 
 * [46] This function TODO
 ********************************************************************************************/
int sys_ftime();

/********************************************************************************************* 
 * [47] This function TODO
 ********************************************************************************************/
int sys_chmod();

/********************************************************************************************* 
 * [48] This function TODO
 ********************************************************************************************/
int sys_fsync();

/********************************************************************************************* 
 * [49] This function TODO
 ********************************************************************************************/
int sys_gettimeofday();

/********************************************************************************************* 
 * [50] This function TODO
 ********************************************************************************************/
int sys_times();


#endif  // _SYSCALLS_H_
