/*
 * hal_drivers.c - Driver initializers for TSAR
 *
 * Copyright (c) 2017 Maxime Villard
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <chdev.h>
#include <hal_drivers.h>
#include <hal_internal.h>

#include <soclib_tty.h>
#include <soclib_xcu.h>

void hal_drivers_txt_init(chdev_t *dev)
{
	soclib_tty_init(dev);
}

/* -------------------------------------------------------------------------- */

void hal_drivers_xcu_init(chdev_t *dev, lid_t lid)
{
	soclib_xcu_init(dev, lid);
}

void hal_drivers_xcu_disable_irq(chdev_t *icu, uint32_t irq_index,
    uint32_t irq_type, lid_t lid)
{
	soclib_xcu_disable_irq(icu, 1 << irq_index, irq_type, lid);
}

void hal_drivers_xcu_enable_irq(chdev_t *icu, uint32_t irq_index,
    uint32_t irq_type, lid_t lid)
{
	soclib_xcu_enable_irq(icu, 1 << irq_index, irq_type, lid);
}

/* -------------------------------------------------------------------------- */

void hal_drivers_pic_init(chdev_t *dev)
{
	/* update the PIC chdev extension */
	pic->ext.pic.enable_timer = &soclib_pic_enable_timer;
	pic->ext.pic.enable_irq   = &soclib_pic_enable_irq;
	pic->ext.pic.disable_irq  = &soclib_pic_disable_irq;
	pic->ext.pic.bind_irq     = &soclib_pic_bind_irq;
	pic->ext.pic.send_ipi     = &soclib_pic_send_ipi;
	pic->ext.pic.extend_init  = &soclib_pic_extend_init;
}
