/*
 * hal_gpt.c - implementation of the Generic Page Table API for TSAR-MIPS32
 *
 * Author   Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH.is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH.is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_gpt.h>
#include <hal_special.h>
#include <printk.h>
#include <bits.h>
#include <process.h>
#include <kmem.h>
#include <thread.h>
#include <cluster.h>
#include <ppm.h>
#include <page.h>

/****************************************************************************************
 * These global variables defines the masks for the Generic Page Table Entry attributes,
 * and must be defined in all GPT implementation.
 ***************************************************************************************/

uint32_t  GPT_MAPPED;
uint32_t  GPT_SMALL;
uint32_t  GPT_READABLE;
uint32_t  GPT_WRITABLE;  
uint32_t  GPT_EXECUTABLE;
uint32_t  GPT_CACHABLE; 
uint32_t  GPT_USER;  
uint32_t  GPT_DIRTY;
uint32_t  GPT_ACCESSED;
uint32_t  GPT_GLOBAL;
uint32_t  GPT_COW;
uint32_t  GPT_SWAP;
uint32_t  GPT_LOCKED;

error_t hal_gpt_create( gpt_t * gpt )
{
	return 0;
}

void hal_gpt_destroy( gpt_t * gpt )
{

}

void hal_gpt_print( gpt_t * gpt )
{

}

error_t hal_gpt_set_pte( gpt_t   * gpt,
                         vpn_t     vpn,
                         ppn_t     ppn,
                         uint32_t  attr )
{
	return 0;
}

void hal_gpt_get_pte( gpt_t    * gpt,
                      vpn_t      vpn,
                      uint32_t * attr,
                      ppn_t    * ppn )
{

}

void hal_gpt_reset_pte( gpt_t * gpt,
                        vpn_t   vpn )
{

}

error_t hal_gpt_lock_pte( gpt_t * gpt,
                          vpn_t   vpn )
{
	return 0;
}

error_t hal_gpt_unlock_pte( gpt_t * gpt,
                            vpn_t   vpn )
{
	return 0;
}

error_t hal_gpt_copy( gpt_t  * dst_gpt,
                      gpt_t  * src_gpt,
                      bool_t   cow )
{
    return 0;
}

