/*
 * hal_kentry.S - exception/interrupt/syscall kernel entry point for MIPS32
 * 
 * AUthors   Ghassan Almaless (2007,2008,2009,2010,2011,2012)
 *           Mohamed Lamine Karaoui (2015)
 *           Alain Greiner (2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */


#---------------------------------------------------------------------------------
# This code is the unique kernel entry point in case of exception, interrupt,
# or syscall for the TSAR_MIPS32 architecture.  
#
# - If the core is in user mode:
#   . we desactivate the MMU.
#   . we save the context in the uzone of the calling thread descriptor.
#   . we increment the cores_in_kernel variable.
#   . we call the relevant exception/interrupt/syscall handler
#
# - If the core is already in kernel mode: 
#   . we save the context in the kernel stack
#   . we call the relevant exception/interrupt/syscall handler
#
# - In both cases, when the handler returns:
#   . we restore the context
#   . we reactivate the MMU ??? 
#---------------------------------------------------------------------------------

	.section   .kentry,"ax",@progbits
	.extern    cpu_do_interrupt
	.extern    cpu_do_exception
	.extern    cpu_do_syscall
	.extern    cpu_kentry
	.extern    cpu_kexit

	.global    kentry
	.global    kentry_load

#define SAVE_SIZE      CPU_REGS_NR*4
#define LID_WIDTH      2
#define CXY_WIDTH      8
#define CXY_MASK       0xFF
#define MMU_MODE_MASK  0xF
#define GID_MASK       0x3FF	
#define LID_MASK       0x3	

#---------------------------------------------------------------------------------
# Kernel Entry point
#---------------------------------------------------------------------------------

kentry:
	
#---------------------------------------------------------------------------------------	
# this code is executed when the core is in user mode:
# - we use the uzone defined in user thread descriptor. 
# - we set the MMU off, and save the CP2_MODE register to uzone.
# - we save the user thread stack pointer to uzone and load the kernel stack pointer
# - we store the uzone pointer in $27

user_mode:

#---------------------------------------------------------------------------------------	
# this code is executed when the core is in kernel mode:
# - we use an uzone allocated in kernel stack.
# - we set the MMU off, set the MMU data_paddr extension to local_cxy,
#   and save the CP2_MODE and CP2_DEXT to uzone.
# - we save the kernel stack pointer to uzone and load the new kernel stack pointer
# - we store the uzone pointer in $27

kernel_mode:

#--------------------------------------------------------------------------------------	
# this code is executed in both modes, with the two following assumptions:
# - $27 contains the pointer on uzone to save the cpu registers
# - $29 contains the kernel stack pointer

unified_mode:	

#---------------------------------------------------------------------------------------
# Depending on XCODE (in $1) , call the apropriate handler. The three called
# functions take the same two arguments: thread pointer and uzone pointer.


cause_excp:

cause_sys:

cause_int:

# -----------------------------------------------------------------------------------
# Kentry exit
# -----------------------------------------------------------------------------------
kentry_exit:

# Possible value for MMU_MODE
# In kernel mode : 0x7/0x3
# In user mode   : 0xF

# DP_EXT can either be local or remote
# Once these register set we can no longuer 
# access global data

out_mmu_F:

out_mmu_7:

out_mmu_3:

out_kentry:

kentry_load:
	# theses nops are required to load the eret instruction
	# while we are in virtual mode (processor pipeline) ?


#-------------------------------------------------------------------------------

