/*
 * hal_syscall.c - Implementation of syscall handler for TSAR-MIPS32.
 * 
 * Author    Alain Greiner (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_syscall.h>
#include <do_syscall.h>
#include <thread.h>
#include <hal_kentry.h>


/////////////////////////////////////
void hal_do_syscall( thread_t * this,
                     reg_t    * regs_tbl )
{
	register reg_t      arg0;
	register reg_t      arg1;
	register reg_t      arg2;
	register reg_t      arg3;
	register reg_t      service_num;
	register reg_t      retval;
  
	service_num = regs_tbl[UZ_V0];

	arg0        = regs_tbl[UZ_A0];
	arg1        = regs_tbl[UZ_A1];
	arg2        = regs_tbl[UZ_A2];
	arg3        = regs_tbl[UZ_A3];
 
    // call architecture independant syscall handler
	retval = do_syscall( this,
                         arg0,
                         arg1,
                         arg2,
                         arg3,
                         service_num );

	regs_tbl[UZ_V0]   = retval;
	regs_tbl[UZ_V1]   = this->errno;
	regs_tbl[UZ_EPC] += 4;
}
