/*
 * hal_kentry.h - MIPS32 registers mnemonics
 * 
 * Copyright (c) 2008,2009,2010,2011,2012 Ghassan Almaless
 * Copyright (c) 2011,2012 UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-kernel.
 *
 * ALMOS-kernel is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-kernel is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-kernel; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HAL_KENTRY_H_
#define _HAL_KENTRY_H_

//////////////////////////////////////////////////////////////////////////////////////////
// This file defines the MIPS32 specific mnemonics to access the "uzone", that is
// a fixed size array of 32 bits integers, used by the kentry function to save/restore 
// the MIPS32 CPU registers, at each exception / interruption / syscall.
// It also defines several initial values for the SR register.
//
// This file is included in the hal_kentry.S, hal_syscall.c, hal_exception.c,
// and hal_context.c files.
//////////////////////////////////////////////////////////////////////////////////////////


/****************************************************************************************
 * This structure defines the cpu_uzone for TSAR MIPS32, as well as the
 *  mnemonics used by the hal_kentry assembly code.
 ***************************************************************************************/

#define      UZ_MODE         0    /* c2_mode */             
#define      UZ_AT           1    /* at_01   */
#define      UZ_V0           2    /* v0_02   */
#define      UZ_V1           3    /* v1_03   */
#define      UZ_A0           4    /* a0_04   */
#define      UZ_A1           5    /* a1_05   */
#define      UZ_A2           6    /* a2_06   */
#define      UZ_A3           7    /* a3_07   */
#define      UZ_T0           8    /* t0_08   */
#define      UZ_T1           9    /* t1_09   */
#define      UZ_T2           10   /* t2_10   */
#define      UZ_T3           11   /* t3_11   */
#define      UZ_T4           12   /* t4_12   */
#define      UZ_T5           13   /* t5_13   */
#define      UZ_T6           14   /* t6_14   */
#define      UZ_T7           15   /* t7_15   */
#define      UZ_T8           16   /* t8_24   */
#define      UZ_T9           17   /* t9_25   */
#define      UZ_S0           18   /* s0_16   */
#define      UZ_S1           19   /* s1_17   */
#define      UZ_S2           20   /* s2_18   */
#define      UZ_S3           21   /* s3_19   */
#define      UZ_S4           22   /* s4_20   */
#define      UZ_S5           23   /* s5_21   */
#define      UZ_S6           24   /* s6_22   */
#define      UZ_S7           25   /* s7_23   */
#define      UZ_S8           26   /* s8_30   */
#define      UZ_GP           27   /* gp_28   */
#define      UZ_RA           28   /* ra_31   */
#define      UZ_EPC          29   /* c0_epc  */
#define      UZ_CR           30   /* c0_cr   */
#define      UZ_SP           31   /* sp_29   */
#define      UZ_SR           32   /* c0_sr   */
#define      UZ_LO           33
#define      UZ_HI           34

#define      UZ_REGS         35

/*************************************************************************************
 * The hal_kentry_enter() function is the unique kernel entry point in case of 
 * exception, interrupt, or syscall for the TSAR_MIPS32 architecture.  
 *
 * When we enter the kernel, we test the status register:
 * - If the core is in user mode, we desactivate the MMU, and we save
 *   the core context in the uzone of the calling thread descriptor.
 * - If the core is already in kernel mode (in case of interrupt), 
 *   we save the context in the kernel stack.
 * - In both cases, we increment the cores_in_kernel variable,
 *   and we call the relevant exception/interrupt/syscall handler
 *
 * When we exit the kernel after handler execution:
 * - we restore the core context from the uzone and return to user space,
 *   calling the hal_kentry_eret()
 ************************************************************************************/
void hal_kentry_enter();

/*************************************************************************************
 * The hal_kentry_eret() function contains only the assembly "eret" instruction,
 * that and the EXL bit in the c0_sr register, and jump to the address 
 * contained in the c0_epc register. 
 * ************************************************************************************/
void hal_kentry_eret();

#endif	/* _HAL_KENTRY_H_ */
