/*
 * sys_thread_sleep.c - put the calling thread in sleep state
 * 
 * Author    Alain Greiner (2016,2017)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_special.h>
#include <scheduler.h>
#include <thread.h>
#include <printk.h>

//////////////////////
int sys_thread_sleep()
{
    thread_t * this = CURRENT_THREAD;

    thread_dmsg("\n[DBG] %s : thread %x in process %x goes to sleep at cycle %d\n",
                __FUNCTION__, this->trdid, this->process->pid, hal_get_cycles() );

    thread_block( this , THREAD_BLOCKED_GLOBAL );
    sched_yield();

    thread_dmsg("\n[DBG] %s : thread %x in process %x resume at cycle\n",
                __FUNCTION__, this->trdid, this->process->pid, hal_get_cycles() );

	return 0;
}  // end sys_thread_sleep()
