/*
 * sys_get_sched.c - display current state of a given scheduler.
 * 
 * Author    Alain Greiner (2016,2017)
 *  
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <errno.h>
#include <cluster.h>


/////////////////////////////////
int sys_get_sched( uint32_t  cxy,
                   uint32_t  lid )
{
	if( cluster_is_undefined( cxy ) )
	{
        printk("\n[ERROR] in %s : undefined cluster identifier %x\n",
        __FUNCTION__ , cxy );
		return -1;
	}

    // call kernel function
    if( cxy == local_cxy )
    {
	    sched_display( lid );
    }
    else
    {
        rpc_sched_display_client( cxy , lid );
    }

	return 0; 

}  // end sys_get_sched()
