///////////////////////////////////////////////////////////////////////////////////////
// File   :  init.c
// Date   :  January 2018
// Author :  Alain Greiner
///////////////////////////////////////////////////////////////////////////////////////
// This single thread application implement the "init" process for ALMOS-MKH. 
// It uses the fork/exec syscalls to create N KSH child processes 
// (one child process per user terminal).
// It includes the hard_config.h file to get th NB_TXT_CHANNELS parameter.
//
// TODO : Register the PIDs for all KSH[i] in a ksh_pid[] array. 
// Then calls the wait() function to block, and reactivate any child KSH process
// that has been deleted, using a new fork/exec.
///////////////////////////////////////////////////////////////////////////////////////

#include <hard_config.h>

#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>

#define DELAY_BETWEEN_FORK 100000

//////////
int main()
{
    int     i;
    int     ret_fork;      // fork return value  
    int     ret_exec;      // fork return value  
    int     received_pid;  // pid received from the wait syscall
    int     status;        // used by the wait syscall
    char    string[64];

    // check number of TXT channels
    assert( NB_TXT_CHANNELS > 1 );

    // create the KSH processes (one per user terminal)
    for( i = 1 ; i <  NB_TXT_CHANNELS ; i++ )
    {

snprintf( string , 64 , "@@@ before fork / iter = %d\n" , i );
display_string( string );

        // INIT process fork process CHILD[i]
        ret_fork = fork();

snprintf( string , 64 , "@@@ after fork / iter = %d / ret_fork = %d\n" , i , ret_fork );
display_string( string );

        if( ret_fork< 0 )   // error in fork
        {
            // INIT display error message on TXT0 terminal 
            snprintf( string , 64 , "init cannot fork child[%d]\n" , i );
            display_string( string );

            // INIT exit
            exit( 0 );
        }
        else if( ret_fork == 0 )                    // we are in CHILD[i] process
        {
            // CHILD[i] process exec process KSH[i]
            ret_exec = exec( "/bin/user/ksh.elf" , NULL , NULL ); 

            if ( ret_exec )   // error in exec              
            {
                // display error message on TXT0 terminal
                snprintf( string , 64 , "child[%d] cannot exec ksh[%d]\n" , i , i );
                display_string( string );

                // CHILD[i] exit
                // exit( 0 );
            }
        }
        else                                      // we are in INIT process
        {
             // INIT display CHILD[i] process PID
             snprintf( string , 64 , "INIT forked CHILD[%d] / pid = %x\n", i , ret_fork ); 
             display_string( string );

             // INIT delay
             int     x;
             for( x=0 ; x<DELAY_BETWEEN_FORK ; x++) asm volatile ("nop");

/*
             // INIT wait exec completion by CHILD[i]
             while( 1 )
             {
                 // get terminating process PID
                 received_pid = wait( &status );

                 if( received_pid == ret_fork ) break;
                 else
                 {
                     snprintf( string , 64 , 
                     "expected_pid %d / received_pid %d" , ret_fork , received_pid  );
                     display_string( string );
                 }
             }

*/
             // INIT display string on kernel TXT0
             snprintf( string , 64 , "INIT created KSH[%d]\n", i );
             display_string( string );
// @@@
display_process( 0 );
display_sched( 0 , 0 );
// @@@
        }

    } 

    // This blocking loop is only for debug, because KSH[i] processes
    // should never be killed, and INIT should never return from the wait() function.
    while( 1 )
    {
        // block on child process termination
        received_pid = wait( &status ); 

        // display string to report unexpected KSH process termination
        snprintf( string , 64 , "KSH process %x unexpectedly terminated" , received_pid );
        display_string( string ); 
    }

} // end main()

