
#put your absolute path to almos-mkh dir here
ALMOS-MKH_DIR = /Users/alain/soc/almos-mkh

LIBC_NAME = mini-libc
#LIBC_NAME = newlib

ARCH_NAME = tsar_mips32
#ARCH_NAME = x86_64

LIBPTHREAD_NAME = mini-libpthread

ifeq ($(ALMOS-MKH_DIR),)
$(error Please define ALMOS-MKH_DIR parameter in params-soft.mk!)
endif


ifeq ($(LIBC_NAME), mini-libc)
  LIBC_PATH = $(ALMOS-MKH_DIR)/libs/mini-libc/
endif
ifeq ($(LIBC_NAME), newlib)
  LIBC_PATH = $(ALMOS-MKH_DIR)/libs/newlib/
endif

ifeq ($(LIBPTHREAD_NAME), mini-libpthread)
  LIBPTHREAD_PATH = $(ALMOS-MKH_DIR)/libs/mini-libpthread/
endif

#Define path to .a and headers files for libc and libpthread
LIBC = $(LIBC_PATH)/build/lib/
LIBC_INCLUDE = $(LIBC_PATH)/build/include/
LIBPTHREAD = $(LIBPTHREAD_PATH)/build/lib/
LIBPTHREAD_INCLUDE = $(LIBPTHREAD_PATH)/build/include/


HAL  = $(ALMOS-MKH_DIR)/hal
KERNEL = $(ALMOS-MKH_DIR)/kernel


ifeq ($(ARCH_NAME), tsar_mips32)
    $(info ARCH_NAME is tsar_mips32)
    export CFLAGS = -Wall -ffreestanding -mno-gpopt -mips32 -g -O2 \
	 	 -fno-delete-null-pointer-checks -std=gnu89
    export CC = mipsel-unknown-elf-gcc
    export AS = mipsel-unknown-elf-as
    export LD = mipsel-unknown-elf-ld
    export DU = mipsel-unknown-elf-objdump
    export AR = mipsel-unknown-elf-ar
    export RANLIB = mipsel-unknown-elf-ranlib
endif

ifeq ($(ARCH_NAME), x86_64)
    $(info ARCH_NAME is x86_64)
    export CFLAGS = -Wall -ffreestanding -mno-red-zone -mno-mmx -mno-sse -mno-avx -g \
      -fno-delete-null-pointer-checks -mcmodel=large -std=gnu89
    export CC = gcc
    export AS = as
    export LD = ld
    export DU = objdump
    export AR = ar
    export RANLIB = ranlib
endif

ifeq ($(ARCH_NAME),)
$(error Your ARCH_NAME is not support, check params-soft.mk!)
endif

BOOTLOADER_PATH = boot/$(ARCH_NAME)
HAL_ARCH = $(HAL)/$(ARCH_NAME)



