///////////////////////////////////////////////////////////////////////////////
// File   :  idbg.c
// Date   :  May 2018
// Author :  Alain Greiner <alain.greiner@lip6.fr>
///////////////////////////////////////////////////////////////////////////////
// This single thread interactive debuger can be used to access and display
// various kernel structures 
///////////////////////////////////////////////////////////////////////////////


#include <stdlib.h>
#include <stdio.h>
#include <shared_syscalls.h>

///////////
void main()
{
    unsigned long long  cycle;

    get_cycle( &cycle );
    printf( "\n[IDBG] starts at cycle %d\n", (unsigned int)cycle ); 

    while (1) 
    {

        ///////
        idbg();
        ///////
    }

    get_cycle( &cycle );
    printf( "\n[IDBG] exit at cycle %d\n", (unsigned int)cycle ); 

    exit( EXIT_SUCCESS );

} // end main()

