#ifndef _SHARED_STAT_H_
#define _SHARED_STAT_H_

/******************************************************************************************
 * This structure define the informations associated to a file descriptor,
 * returned to user space by the stat() system call.
 *****************************************************************************************/

typedef struct stat 
{
	unsigned int    dev;        /*! ID of device containing file                             */
	unsigned int    inum;       /*! inode number                                             */
	unsigned int    mode;       /*! protection                                               */
	unsigned int    nlink;      /*! number of hard links                                     */
	unsigned int    uid;        /*! user ID of owner                                         */
	unsigned int    gid;        /*! group ID of owner                                        */
	unsigned int    rdev;       /*! device ID (if special file)                              */
	unsigned int    size;       /*! total size, in bytes                                     */
	unsigned int    blksize;    /*! blocksize for file system I/O                            */
	unsigned int    blocks;     /*! number of 512B blocks allocated                          */
}
stat_t;

#endif /* _STAT_H_ */
